/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.lakala.response.trade.info;

import lombok.Data;

import java.io.Serializable;

/**
 * @author wangyi
 * @version LakalaBankPayRefundQueryInfoResponse.java, v 0.1 2023-10-12 09:23 wangyi
 */
@Data
public class LakalaBankPayRefundQueryInfoResponse implements Serializable {

    private static final long serialVersionUID = 4291386309580628575L;

    /**
     * 交易流水号
     */
    private String tradeNo;

    /**
     * 对账单流水号
     */
    private String logNo;

    /**
     * 交易参考号
     */
    private String tradeRefNo;

    /**
     * 交易类型
     */
    private String tradeType;

    /**
     * 支付状态
     */
    private String tradeStatus;

    /**
     * 交易金额，单位：分
     */
    private Long tradeAmount;

    /**
     * 付款人实际支付金额，单位：分
     */
    private Long payerAmount;

    /**
     * 用户标识1，微信sub_open_id、支付宝buyer_logon_id（买家支付宝账号）
     */
    private String userId1;

    /**
     * 用户标识2，微信openId、支付宝buyer_user_id、银联user_id
     */
    private String userId2;

    /**
     * 交易完成时间，格式: yyyy-MM-dd HH:mm:ss
     */
    private String tradeTime;

    /**
     * 付款受理交易流水号，支付宝流水号、微信流水号
     */
    private String accTradeNo;

    /**
     * 付款人账号
     */
    private String payerAccountNo;

    /**
     * 付款人名称（仅ONLINE交易返回）
     */
    private String payerName;

    /**
     * 付款账号开户行
     */
    private String payerAccountBank;

    /**
     * 账户类型，C-贷记 D-借记 U-未知
     */
    private String accType;

    /**
     * 业务类型
     */
    private String busiMode;

    /**
     * 钱包类型
     */
    private String tranAccIssino;

    /**
     * 付款方式
     */
    private String payMode;

    /**
     * 终端批次号，只有busi_type为UPCARD时返回
     */
    private String clientBatchNo;

    /**
     * 终端流水号，只有busi_type为UPCARD时返回
     */
    private String clientSeqNo;

    /**
     * 结算商户号
     */
    private String settleMerchantNo;

    /**
     * 结算终端号
     */
    private String settleTermNo;

    /**
     * 交易备注
     */
    private String tradeRemark;
}