/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.response.trade.accbusifields;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;

import java.io.Serializable;

/**
 * 账户端返回信息域
 *
 * @author liluqing
 * @version LakalaPreOrderAccBusiResponse.java, v 0.1 2022-03-07 12:49
 */
@Data
public class LakalaPreOrderAccBusiResponse implements Serializable {
    private static final long serialVersionUID = 3690269131373510532L;

    /****************************支付宝(41-NATIVE)场景下返回acc_resp_fields域******************************/

    /**
     * 二维码信息 (必填参数)
     * 商户可用此参数自定义去生成二维码后展示出来进行扫码支付
     */
    private String code;

    /**
     * 二维码图片内容 (必填参数)
     * <strong>商户收款二维码图片。Base64编码，暂无</strong>
     */
    private String codeImage;
    /***************************支付宝(41-NATIVE)场景下返回acc_resp_fields域*******************************/


    /****************************支付宝(51-JSAPI)场景下返回acc_resp_fields域******************************/

    /**
     * 预下单Id (必填参数)
     * 预支付交易会话ID
     */
    private String prepayId;

    /***************************支付宝(51-JSAPI)场景下返回acc_resp_fields域*******************************/

    /****************************支付宝(81-H5)场景下返回acc_resp_fields域******************************/

    /**
     * 为开发者生成前台页面请求需要的完整form 表单的 html（不包含自动提交脚本），商户可决定是否直接提交 form 表单，如需要直接提交的，可将这个表单的 String 加自动提交脚本输出到 http response 中，如不需要直接提交的，可以自行决定中间处理过程，但提交至支付宝侧的 form 表达内容不可修改，否则会引起支付宝侧报错。 (必填参数)
     * <strong>为银联支付宝H5支付时，为开发者生成前台页面请求需要的完整form 表单的 html</strong>
     */
    private String formData;

    /***************************支付宝(81-H5)场景下返回acc_resp_fields域*******************************/

    /****************************微信(71-小程序)微信(51-JSAPI)场景下返回acc_resp_fields域******************************/
    /**
     * 支付签名信息 (必填参数)
     * 签名
     */
    private String paySign;

    /**
     * 小程序id (必填参数)
     * 商户注册具有支付权限的小程序成功后即可获得小程序id
     */
    private String appId;

    /**
     * 时间戳 (必填参数)
     * 当前的时间
     */
    private String timeStamp;

    /**
     * 随机字符串 (必填参数)
     * 随机字符串
     */
    private String nonceStr;

    /**
     * 订单详情扩展字符串 (必填参数)
     */
    @JSONField(name = "package")
    private String packageDetail;

    /**
     * 签名方式 (必填参数)
     * 签名类型，支持RSA
     */
    private String signType;

    /***************************微信(71-小程序)微信(51-JSAPI)场景下返回acc_resp_fields域*******************************/

    /***************************银联二维码(51-JSAPI)场景下返回acc_resp_fields域*******************************/
    /**
     * 银联JS支付重定向地址 (必填参数)
     * 银联JS支付返回重定向地址
     */
    private String redirectUrl;
    /***************************银联二维码(51-JSAPI)场景下返回acc_resp_fields域*******************************/

    /***************************翼支付(51-JSAPI)场景下返回acc_resp_fields域*******************************/
    /**
     * 翼支付JS参数
     * 翼支付JS参数(老网联) best_pay_info、redirect_url两者有其一
     */
    private String bestPayInfo;
    /***************************翼支付(51-JSAPI)场景下返回acc_resp_fields域*******************************/
}