/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.response.trade.accbusifields;

import lombok.Data;

import java.io.Serializable;

/**
 * 订单查询账户端返回信息域
 *
 * @author liluqing
 * @version LakalaOrderQueryAccBusiResponse.java, v 0.1 2022-03-07 13:44
 */
@Data
public class LakalaOrderQueryAccBusiResponse implements Serializable {

    private static final long serialVersionUID = 8975856613085727260L;
    /**
     * 买家在支付宝的用户id (必填参数)
     * 支付宝-buyer_user_id
     * 微信-sub_open_id
     * 银联-userId
     */
    private String userId;

    /****************************支付宝二维码被扫场景下返回acc_resp_fields域内容  start ******************************/
    /**
     * 支付宝的店铺编号 (选填)
     */
    private String alipayStoreId;

    /**
     * 交易支付使用的资金渠道(待上线) (选填)
     */
    private String fundBillList;

    /**
     * 所有优惠券信息(待上线) (选填)
     */
    private String voucherDetailList;
    /****************************支付宝二维码被扫场景下返回acc_resp_fields域内容  end ******************************/

    /****************************微信二维码被扫场景下返回acc_resp_fields域内容  start ******************************/
    /**
     * 用户标识 (必填参数)
     * 用户在商户appid下的唯一标识
     */
    private String openId;

    /**
     * 活动 ID (选填)
     * 在账户端商户后台配置的批次 ID
     */
    private String accActivityId;

    /**
     * 优惠功能信息(待上线) (选填)
     */
    private String promotionDetail;
    /****************************微信二维码被扫场景下返回acc_resp_fields域内容  end ******************************/

    /****************************银联二维码被扫场景下返回acc_resp_fields域内容  start ******************************/
    /**
     * 银联单品营销 附加数据(待上线) (选填)
     * 参与单品营销优惠时返回
     */
    private String upIssAddnData;

    /**
     * 银联优惠信息/出资方信息(待上线) (选填)
     * 参与单品营销优惠时返回
     */
    private String upCouponInfo;
    /****************************银联二维码被扫场景下返回acc_resp_fields域内容  end ******************************/

    /**
     * 出资方信息 (选填)
     * 数字货币中行返回示例说明：[{“fundchannel”:”BOC”,”amount”:”18”}]
     */
    private String tradeInfo;

}