/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.response.settle;

import com.fshows.lakala.response.base.LakalaBizResponse;
import lombok.Data;

/**
 * 分账完成请求响应结果
 *
 * @author liluqing
 * @version LakalaSettleLedgerResponse.java, v 0.1 2022-03-08 9:58
 */
@Data
public class LakalaSettleLedgerResponse extends LakalaBizResponse {

    private static final long serialVersionUID = -6324796417057737729L;

    /**
     * 响应码 (选填)
     * 0000：受理成功<br>0001：必传值为空<br>0002：请求流水处理中 –完成交易<br>0003：原暂缓交易已完成处理 –完成交易请求和兜底发起的判定<br>0004：原请求流水状态不符 –完成回退<br>0005：查询失败，原交易不存在<br>0006：原暂缓交易状态异常:计费失败– 可以重试<br>0007：原暂缓交易状态异常:记账失败 –可以重试<br>0008：转入list数量超限<br>0009: 转入list商终不存在<br>0010：商终不存在<br>0011：余额不足<br>0012：分账金额不符合最大分账比例<br>0013：商户未开启分账功能<br>0014：完成分账,分账金额超过交易总金额<br>0015：累计回退金额超过原分账金额<br>0016：完成明细入库异常<br>0099: 系统异常<br>1000：处理成功
     */
    private String code;

    /**
     * 描述 (选填)
     */
    private String msg;
}