/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.response.base;

import lombok.Data;

import java.io.Serializable;

/**
 * 全局响应公共参数基类
 *
 * @author liluqing
 * @version LakalaBaseResponse.java, v 0.1 2022-03-02 11:27
 */
@Data
public abstract class LakalaBaseResponse<E extends LakalaBizResponse> implements Serializable {

    private static final long serialVersionUID = 1063737463083778025L;

    /**
     * 获取业务参数
     *
     * @return
     */
    public abstract String getCode();

    /**
     * 返回业务描述
     *
     * @return
     */
    public abstract String getMsg();

    /**
     * 获取业务参数
     *
     * @return
     */
    public abstract E getRespData();

    /**
     * 请求是否处理成功（根据code判断）
     *
     * @return
     */
    public abstract boolean isSuccess();
}