/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.trade.pay.accbusifields.wx;

import com.fshows.lakala.request.trade.pay.accbusifields.BaseAccBusiFieldsRequest;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

/**
 * 微信主扫场景下acc_busi_fields域内容
 *
 * @author liluqing
 * @version WxPreOrderAccBusiRequest.java, v 0.1 2022-03-07 11:53
 */
@Data
public class WxPreOrderAccBusiRequest extends BaseAccBusiFieldsRequest {

    private static final long serialVersionUID = -8896640328938287434L;
    /**
     * 预下单有效时间 (选填)
     * 预下单的订单的有效时间，以分钟为单位。如果在有效时间内没有完成付款，则在账户端该订单失效。如果不上送，以账户端订单失效时间为准。 建议不超过15分钟。不传值则默认5分钟。
     */
    @Length(max = 2, message = "预下单有效时间长度不能超过2")
    private String timeoutExpress;

    /**
     * 子商户公众账号ID (选填)
     * 微信分配的子商户公众账号ID，sub_appid（即微信小程序支付-71、公众号支付-51），此参数必传，只对微信支付有效 工行数字钱包情况下，该字段上送工行的openId 拉卡拉钱包情况下，该字段上送LAKALA的userId
     */
    @Length(max = 32, message = "子商户公众账号ID长度不能超过32")
    private String subAppid;

    /**
     * 用户标识 (选填)
     * 用户在子商户sub_appid下的唯一标识，sub_openid，（即微信小程序支付-71、众号支付-51），此参数必传，只对微信支付有效
     */
    @Length(max = 64, message = "用户标识长度不能超过64")
    private String userId;

    /**
     * 商品详情 (选填)
     * 单品优惠功能字段，详见下文说明
     */
    @Length(max = 1024, message = "商品详情长度不能超过1024")
    private String detail;

    /**
     * 订单优惠标记 (选填)
     * 订单优惠标记，微信平台配置的商品标记，用于优惠券或者满减使用，accountType为WECHAT时，可选填此字段
     */
    @Length(max = 32, message = "订单优惠标记长度不能超过32")
    private String goodsTag;

    /**
     * 附加域 (选填)
     * 附加数据，在查询API和支付通知中原样返回，该字段主要用于商户携带订单的自定义数据。商户定制字段，直接送到账户端。
     */
    @Length(max = 128, message = "附加域长度不能超过128")
    private String attach;

    /**
     * 设备号 (选填)
     * 终端设备号(门店号或收银设备ID)，注意：PC网页或JSAPI支付请传”WEB”
     */
    @Length(max = 32, message = "设备号长度不能超过32")
    private String deviceInfo;

    /**
     * 指定支付方式 (选填)
     * no_credit–指定不能使用信用卡支付
     */
    @Length(max = 20, message = "指定支付方式长度不能超过20")
    private String limitPay;
}