/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.lakala.request.trade.order;

import com.fshows.lakala.enums.trade.LakalaTradeApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.trade.order.LakalaBankPayTransQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 刷卡订单退款查询接口
 *
 * @author wangyi
 * @version LakalaBankPayRefundQueryRequest.java, v 0.1 2022-03-04 17:22
 */
@Data
public class LakalaBankPayTransQueryRequest extends LakalaBizRequest<LakalaBankPayTransQueryResponse, LakalaTradeApiDefinitionEnum> {

    private static final long serialVersionUID = 6447099511882715208L;

    /**
     * 商户号 (必填参数)
     * 拉卡拉分配的商户号
     */
    @NotBlank
    @Length(max = 32, message = "商户号长度不能超过32")
    private String merchantNo;

    /**
     * 外部请求唯一标识
     */
    private String outTradeNo;

    /**
     * 外部商户订单号
     */
    private String outOrderNo;

    /**
     * 支付交易受理流水号
     */
    private String logNo;

    /**
     * 受理终端号
     */
    private String termNo;
}