/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.lakala.request.settle;

import com.fshows.lakala.enums.settle.LakalaSettleApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.settle.LakalaWithdrawQueryResponse;
import lombok.Data;

/**
 * 提现结果查询
 *
 * @author liluqing
 * @version LakalaWithdrawQueryRequest.java, v 0.1 2023-02-28 14:30
 */
@Data
public class LakalaWithdrawQueryRequest extends LakalaBizRequest<LakalaWithdrawQueryResponse, LakalaSettleApiDefinitionEnum> {
    private static final long serialVersionUID = -727852660595907292L;

    /**
     * bmcp机构号
     */
    private String orgNo;

    /**
     * 商户号
     */
    private String merchantNo;

    /**
     * 提款流水号（二选一）
     */
    private String drawJnl;

    /**
     * 商户订单号（二选一）
     */
    private String merOrderNo;
}