package com.fshows.lakala.request.merchant;

import com.fshows.lakala.enums.merchant.LakalaMerchantApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.merchant.LakalaDeviceForceUnactiveResponse;
import com.fshows.lakala.response.merchant.LakalaWechatRealNameQueryResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 设备解绑请求
 *
 * @author liangyuanping
 * @version LakalaWechatRealNameQueryRequest.java, v 0.1 2023-02-23 9:47 AM
 */
@Data
public class LakalaDeviceForceUnactiveRequest extends LakalaBizRequest<LakalaDeviceForceUnactiveResponse, LakalaMerchantApiDefinitionEnum> {

    /**
     * 接口版本号 (必填参数)
     */
    @NotBlank
    @Length(max = 8, message = "接口版本号长度不能超过8")
    private String version;

    /**
     * 订单编号 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "订单编号长度不能超过32")
    private String orderNo;

    /**
     * 机构代码 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "机构代码长度不能超过32")
    private String orgCode;

    /**
     * 终端设备序列号
     */
    private String devSerialNo;

}