/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.merchant;

import com.fshows.lakala.enums.merchant.LakalaMerchantApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.merchant.LakalaAddTermResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 商户进价
 *
 * @author liluqing
 * @version LakalaAddMerchantRequest.java, v 0.1 2022-03-08 15:48
 */
@Data
public class LakalaAddTermRequest extends LakalaBizRequest<LakalaAddTermResponse, LakalaMerchantApiDefinitionEnum> {

    private static final long serialVersionUID = 8441206421249264084L;

    /**
     * 接口版本号 (必填参数)
     * 1.0
     */
    @NotBlank
    @Length(max = 8, message = "接口版本号长度不能超过8")
    private String version;

    /**
     * 订单编号（便于后续跟踪排查问题及核对报文） (必填参数)
     * 14位年月日时（24小时制）分秒+8位的随机数（不重复）如：2021020112000012345678
     */
    @NotBlank
    @Length(max = 32, message = "订单编号（便于后续跟踪排查问题及核对报文）长度不能超过32")
    private String orderNo;

    /**
     * 进件POS类型 —按接入系统做控制，参见【POS类型字典表】 (必填参数)
     * GENERAL_POS
     */
    @NotBlank
    @Length(max = 32, message = "进件POS类型 —按接入系统做控制，参见【POS类型字典表】长度不能超过32")
    private String posType;

    /**
     * 机构代码 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "机构代码长度不能超过32")
    private String orgCode;

    /**
     * 商户内部商户号(拉卡拉内部商户号和银联商户号必须传一个，都送以内部商户号为准) (必填参数)
     * 4002019111800000020
     */
    @Length(max = 32, message = "商户内部商户号(拉卡拉内部商户号和银联商户号必须传一个，都送以内部商户号为准)长度不能超过32")
    private String merInnerNo;

    /**
     * 银联商户号 (必填参数)
     * 82229005411000A
     */
    @Length(max = 32, message = "银联商户号长度不能超过32")
    private String merCupNo;

    /**
     * 新增网点 (选填)
     */
    private LakalaShopDataRequest shopData;

    /**
     * 终端详情 (必填参数)
     */
    @NotNull
    private LakalaTermDataRequest termData;

    /**
     * 回调地址 (必填参数)
     * http://
     */
    @NotBlank
    @Length(max = 64, message = "回调地址长度不能超过64")
    private String retUrl;

    /**
     * 费率信息集合 (必填参数)
     * 参看下方【费率信息】
     */
    @NotNull
    private List<LakalaFeeRateRequest> feeData;

    /**
     * 附件信息集合 (选填)
     */
    private List<LakalaFileDataRequest> fileData;

}