/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.response.trade.pay;

import com.fshows.lakala.response.base.LakalaBizResponse;
import com.fshows.lakala.response.trade.accbusifields.LakalaPreOrderAccBusiResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 主扫接口响应参数
 *
 * @author liluqing
 * @version LakalaPreOrderCreateResponse.java, v 0.1 2022-03-01 22:17
 */
@Data
public class LakalaPreOrderCreateResponse extends LakalaBizResponse {

    private static final long serialVersionUID = -7691015297185268211L;

    /**
     * 商户号 (必填参数)
     * 拉卡拉分配的商户号（请求接口中商户号）
     */
    @NotBlank
    @Length(max = 32, message = "商户号长度不能超过32")
    private String merchantNo;

    /**
     * 商户请求流水号 (必填参数)
     * 请求报文中的商户请求流水号
     */
    @NotBlank
    @Length(max = 32, message = "商户请求流水号长度不能超过32")
    private String outTradeNo;

    /**
     * 拉卡拉交易流水号 (必填参数)
     * 拉卡拉交易流水号
     */
    @NotBlank
    @Length(max = 32, message = "拉卡拉交易流水号长度不能超过32")
    private String tradeNo;

    /**
     * 拉卡拉对账单流水号 (必填参数)
     * 拉卡拉对账单流水号
     */
    @NotBlank
    @Length(max = 14, message = "拉卡拉对账单流水号长度不能超过14")
    private String logNo;

    /**
     * 结算商户号 (必填参数)
     * 拉卡拉分配的商户号
     */
    @NotBlank
    @Length(max = 32, message = "结算商户号长度不能超过32")
    private String settleMerchantNo;

    /**
     * 结算终端号 (必填参数)
     * 拉卡拉分配的业务终端号
     */
    @NotBlank
    @Length(max = 32, message = "结算终端号长度不能超过32")
    private String settleTermNo;

    /**
     * 账户端返回信息域 (选填)
     * 账户端返回信息域
     */
    private LakalaPreOrderAccBusiResponse accRespFields;

}