/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.trade.pay.accbusifields.alipay;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 支付宝业务扩展参数
 *
 * @author liluqing
 * @version AlipayExtendParamsRequest.java, v 0.1 2022-03-07 11:50
 */
@Data
public class AlipayExtendParamsRequest implements Serializable {

    private static final long serialVersionUID = 3171982470263965680L;

    /**
     * 服务商的PID (选填)
     * 系统商编号，该参数作为系统商返佣数据提取的依据，请填写系统商签约协议的 PID
     */
    @Length(max = 64, message = "服务商的PID长度不能超过64")
    private String sysServiceProviderId;

    /**
     * 花呗分期期数 (必填参数)
     * 支付宝花呗分期必送字段: 花呗分期数 3：3期 6：6期 12：12期
     */
    @NotBlank
    @Length(max = 5, message = "花呗分期期数长度不能超过5")
    private String hbFqNum;

    /**
     * 卖家承担手续费比例 (必填参数)
     * 支付宝花呗分期必送字段: 卖家承担收费比例，商家承担手续费传入100，用户承担手续费传入0，仅支持传入100、0两种，其他比例暂不支持 100：代表商家贴息 0：代表用户承担手续费
     */
    @NotBlank
    @Length(max = 3, message = "卖家承担手续费比例长度不能超过3")
    private String hbFqSellerPercent;

    /**
    * 点餐场景类型：
     * qr_order（店内扫码点餐），pre_order（预点到店自提），home_delivery （外送到家），direct_payment（直接付款），other（其它）
    */
    private String foodOrderType;
}