/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.trade.order;

import com.fshows.lakala.enums.trade.LakalaTradeApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.request.trade.pay.LakalaLocationInfoRequest;
import com.fshows.lakala.response.trade.order.LakalaCloseResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 关单交易
 *
 * @author liluqing
 * @version LakalaCloseRequest.java, v 0.1 2022-03-07 14:03
 */
@Data
public class LakalaCloseRequest extends LakalaBizRequest<LakalaCloseResponse, LakalaTradeApiDefinitionEnum> {

    private static final long serialVersionUID = 3950428064157510877L;

    /**
     * 商户号 (必填参数)
     * 拉卡拉分配的商户号
     */
    @NotBlank
    @Length(max = 32, message = "商户号长度不能超过32")
    private String merchantNo;

    /**
     * 终端号 (必填参数)
     * 拉卡拉分配的商户号
     */
    @NotBlank
    @Length(max = 32, message = "终端号长度不能超过32")
    private String termNo;

    /**
     * 原商户交易流水号 (选填)
     * 下单时商户请求流水号 origin_out_trade_no、origin_trade_no、origin_out_order_source+origin_out_order_no必有其一， 前两者为交易关单，后者为商户订单关单
     */
    @Length(max = 32, message = "原商户交易流水号长度不能超过32")
    private String originOutTradeNo;

    /**
     * 原交易拉卡拉交易流水号 (选填)
     * 下单成功时，返回的SAAS生成的交易流水
     */
    @Length(max = 32, message = "原交易拉卡拉交易流水号长度不能超过32")
    private String originTradeNo;

    /**
     * 地址位置信息 (必填参数)
     * 地址位置信息，风控要求必送
     */
    @NotNull
    private LakalaLocationInfoRequest locationInfo;

}