/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.settle;

import com.fshows.lakala.enums.settle.LakalaSettleApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.settle.LakalaQueryEwalletSettleResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 钱包提款模式查询
 *
 * @author liluqing
 * @version LakalaQueryEwalletSettleRequest.java, v 0.1 2022-03-08 10:22
 */
@Data
public class LakalaQueryEwalletSettleRequest extends LakalaBizRequest<LakalaQueryEwalletSettleResponse, LakalaSettleApiDefinitionEnum> {

    private static final long serialVersionUID = 7160324677427166072L;

    /**
     * BMCP机构号 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "BMCP机构号长度不能超过32")
    private String bmcpNo;

    /**
     * 822商户号 或 receiveNo	 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "822商户号 或 receiveNo长度不能超过32")
    private String mercId;
}