package com.fshows.lakala.enums.activity;

import org.apache.commons.lang3.StringUtils;

/**
 * 拉卡拉结算API响应码枚举
 *
 * @author liluqing
 * @version LakalaSettleResponseCodeEnum.java, v 0.1 2022-03-02 11:04 liluqing
 */
public enum LakalaActivityResponseCodeEnum {
    SUCCESS("成功", "000000");

    private String name;
    private String value;

    LakalaActivityResponseCodeEnum(String name, String value) {
        this.name = name;
        this.value = value;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

    public static LakalaActivityResponseCodeEnum getByValue(String value) {
        LakalaActivityResponseCodeEnum[] valueList = LakalaActivityResponseCodeEnum.values();
        for (LakalaActivityResponseCodeEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }
}