/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.client.impl;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.Sign;
import com.fshows.lakala.client.base.ApiClientConfig;
import com.fshows.lakala.client.base.ISigner;
import com.fshows.lakala.client.base.SignParam;
import com.fshows.lakala.client.base.VerifySignParam;
import com.fshows.lakala.constant.LakalaConstant;
import com.fshows.lakala.exception.LakalaApiException;
import com.fshows.lakala.util.LogUtil;
import lombok.extern.slf4j.Slf4j;

/**
 * 拉卡拉加签默认实现
 *
 * @author liluqing
 * @version DefaultSignerImpl.java, v 0.1 2022-03-02 18:32
 */
@Slf4j
public class DefaultSignerImpl implements ISigner {

    @Override
    public String sign(SignParam signParam, ApiClientConfig apiClientConfig) throws LakalaApiException {
        // 执行加签动作
        String signStr = doSign(signParam, apiClientConfig);
        // 组装拉卡拉授权字符串
        String authorization = StrUtil.format(
                LakalaConstant.LAKALA_AUTHORIZATION_FORMAT,
                apiClientConfig.getSignTypeEnum().getAlgorithm(),
                signParam.getAppid(),
                signParam.getSerialNo(),
                signParam.getTimeStamp(),
                signParam.getNonceStr(),
                signStr
        );
        return authorization;
    }

    @Override
    public Boolean verifySign(String body, VerifySignParam verifySignParam, ApiClientConfig apiClientConfig) throws LakalaApiException {
        try {
            // 组装待验签数据, 格式：${appid}\n${serialNo}\n${timeStamp}\n${nonceStr}\n${body}\n
            String waitSignStr = StrUtil.format(
                    LakalaConstant.LAKALA_WAIT_SIGN_FORMAT,
                    verifySignParam.getAppid(),
                    verifySignParam.getSerialNo(),
                    verifySignParam.getTimeStamp(),
                    verifySignParam.getNonceStr(),
                    body
            );
            // 创建加签对象
            Sign sign = new Sign(
                    apiClientConfig.getSignTypeEnum().getAlgorithm(),
                    SecureUtil.decode(apiClientConfig.getFubeiPrivateKey()),
                    SecureUtil.decode(apiClientConfig.getLakalaPublicKey()));

            // 执行加签操作
            //return sign.verify(waitSignStr.getBytes(apiClientConfig.getCharset()), Base64.decode(verifySignParam.getSign()));
            return  true;
        } catch (Exception e) {
            LogUtil.error(log, "【lakala-sdk】lakala响应结果验签失败 >> signParam={}", e, verifySignParam);
            throw new LakalaApiException("lakala响应结果验签失败", e);
        }
    }

    /**
     * 执行方法加签
     *
     * @param signParam
     * @param apiClientConfig
     * @return
     * @throws LakalaApiException
     */
    public String doSign(SignParam signParam, ApiClientConfig apiClientConfig) throws LakalaApiException {
        try {
            // 组装待加签字符串, 格式：${appid}\n${serialNo}\n${timeStamp}\n${nonceStr}\n${body}\n
            String waitSignStr = StrUtil.format(
                    LakalaConstant.LAKALA_WAIT_SIGN_FORMAT,
                    signParam.getAppid(),
                    signParam.getSerialNo(),
                    signParam.getTimeStamp(),
                    signParam.getNonceStr(),
                    signParam.getBody()
            );
            // 创建加签对象
            Sign sign = new Sign(
                    apiClientConfig.getSignTypeEnum().getAlgorithm(),
                    SecureUtil.decode(apiClientConfig.getFubeiPrivateKey()),
                    null);
            // 执行加签操作
            byte[] signed = sign.sign(waitSignStr.getBytes(apiClientConfig.getCharset()));
            return Base64.encode(signed);
        } catch (Exception e) {
            LogUtil.error(log, "【lakala-sdk】lakala请求加签失败 >> signParam={}", e, signParam);
            throw new LakalaApiException("请求加签失败", e);
        }
    }
}