/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.client.base;

import com.fshows.lakala.exception.LakalaApiException;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.base.LakalaBaseResponse;
import com.fshows.lakala.response.base.LakalaBizResponse;

/**
 * 拉卡拉API客户端
 *
 * @author liluqing
 * @version LakalaApiClient.java, v 0.1 2022-03-02 11:17
 */
public interface ILakalaApiClient {

    /**
     * 调用拉卡拉交易相关接口
     *
     * @param request
     * @param <T>
     * @return
     */
    <T extends LakalaBizResponse, R extends ILakalaApiDefinition> LakalaBaseResponse<T> execute(LakalaBizRequest<T,R> request, R tradeApiDefinitionEnum) throws LakalaApiException;
}