/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lakala.client.impl;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fshows.lakala.client.base.ApiClientConfig;
import com.fshows.lakala.client.base.IHttpRequest;
import com.fshows.lakala.client.base.ILakalaApiDefinition;
import com.fshows.lakala.client.base.ISigner;
import com.fshows.lakala.client.base.LakalaHttpResult;
import com.fshows.lakala.client.base.SignParam;
import com.fshows.lakala.client.impl.AbstractLakalaApiClientImpl;
import com.fshows.lakala.exception.LakalaApiException;
import com.fshows.lakala.request.base.LakalaBaseMerchantRequest;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.base.LakalaBaseMerchantResponse;
import com.fshows.lakala.response.base.LakalaBaseResponse;
import com.fshows.lakala.response.base.LakalaBizResponse;
import com.fshows.lakala.util.LogUtil;
import com.fshows.lakala.util.ReqIdUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LakalaUploadFileClientImpl
extends AbstractLakalaApiClientImpl<LakalaBaseMerchantRequest, LakalaBaseMerchantResponse> {
    private static final Logger log = LoggerFactory.getLogger(LakalaUploadFileClientImpl.class);
    private static SerializeConfig serializeConfig = new SerializeConfig();

    public LakalaUploadFileClientImpl(ApiClientConfig apiClientConfig) throws LakalaApiException {
        super(apiClientConfig);
    }

    public LakalaUploadFileClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws LakalaApiException {
        super(apiClientConfig, httpRequest, signer);
    }

    @Override
    public <T extends LakalaBizResponse, R extends ILakalaApiDefinition> LakalaBaseResponse<T> execute(LakalaBizRequest<T, R> bizRequest, R merchantApiDefinitionEnum) throws LakalaApiException {
        String url = null;
        try {
            this.checkParam(bizRequest, merchantApiDefinitionEnum);
            LakalaBaseMerchantRequest lakalaBaseRequest = this.buildLakalaBizRequest(bizRequest, merchantApiDefinitionEnum);
            String body = this.serializableRequest(lakalaBaseRequest, merchantApiDefinitionEnum);
            SignParam signParam = this.buildSignParam(lakalaBaseRequest, body);
            String authorization = this.signer.sign(signParam, this.apiClientConfig);
            url = this.getServerURL(merchantApiDefinitionEnum);
            LakalaHttpResult result = this.doRequest(url, authorization, signParam.getBody());
            return this.parseResponse(result.getBody(), merchantApiDefinitionEnum);
        }
        catch (LakalaApiException e) {
            LogUtil.error(log, "\u3010lakala-sdk\u3011\u62c9\u5361\u62c9\u8bf7\u6c42\u5f02\u5e38 >> url={}", e, url);
            throw e;
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010lakala-sdk\u3011\u62c9\u5361\u62c9\u8bf7\u6c42\u5f02\u5e38 >> url={}", e, url, bizRequest);
            throw new LakalaApiException(e.getMessage(), e);
        }
    }

    private LakalaHttpResult doRequest(String url, String authorization, String requestBody) throws LakalaApiException {
        long beginTime = System.currentTimeMillis();
        try {
            LogUtil.info(log, "\u3010lakala-sdk\u3011\u8bf7\u6c42\u5f00\u59cb >> doRequest >> url={},begin={}", url, beginTime);
            LakalaHttpResult result = this.httpRequest.post(url, authorization, requestBody, this.apiClientConfig);
            if (null == result) {
                throw new LakalaApiException("lakala\u76f8\u5e94\u7ed3\u679c\u4e3a\u7a7a");
            }
            LogUtil.info(log, "\u3010lakala-sdk\u3011\u8bf7\u6c42\u7ed3\u675f >> doRequest >> url={},response={},lakalTraceId={},cost={}", url, result.getBody(), result.getLakalaTraceId(), System.currentTimeMillis() - beginTime);
            return result;
        }
        catch (LakalaApiException e) {
            LogUtil.error(log, "\u3010lakala-sdk\u3011\u62c9\u5361\u62c9\u8bf7\u6c42\u5f02\u5e38 >> doRequest >> url={}, cost={}", url, System.currentTimeMillis() - beginTime);
            throw e;
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010lakala-sdk\u3011\u62c9\u5361\u62c9\u8bf7\u6c42\u5f02\u5e38 >> doRequest >> url={}, cost={}", url, System.currentTimeMillis() - beginTime);
            throw new LakalaApiException("\u8bf7\u6c42\u62c9\u5361\u62c9\u63a5\u53e3\u5f02\u5e38", e);
        }
    }

    @Override
    protected LakalaBaseMerchantRequest buildLakalaBizRequest(LakalaBizRequest bizRequest, ILakalaApiDefinition merchantApiDefinitionEnum) {
        LakalaBaseMerchantRequest<LakalaBizRequest> baseMerchantRequest = new LakalaBaseMerchantRequest<LakalaBizRequest>();
        baseMerchantRequest.setTimestamp(System.currentTimeMillis());
        baseMerchantRequest.setRnd(RandomUtil.randomString((int)12));
        baseMerchantRequest.setVer(merchantApiDefinitionEnum.getVersion());
        baseMerchantRequest.setReqId(ReqIdUtil.getId());
        baseMerchantRequest.setReqData(bizRequest);
        return baseMerchantRequest;
    }

    @Override
    protected SignParam buildSignParam(LakalaBaseMerchantRequest lakalaBaseRequest, String bodyStr) {
        SignParam signParam = new SignParam();
        signParam.setAppid(this.apiClientConfig.getAppId());
        signParam.setSerialNo(this.apiClientConfig.getSerialNo());
        signParam.setBody(bodyStr);
        signParam.setNonceStr(lakalaBaseRequest.getRnd());
        signParam.setTimeStamp(lakalaBaseRequest.getTimestamp() / 1000L);
        return signParam;
    }

    @Override
    protected String serializableRequest(LakalaBaseMerchantRequest lakalaBaseRequest, ILakalaApiDefinition tradeApiDefinitionEnum) {
        return JSONObject.toJSONString((Object)lakalaBaseRequest, (SerializeConfig)serializeConfig, (SerializerFeature[])new SerializerFeature[0]);
    }

    @Override
    protected LakalaBaseMerchantResponse parseResponse(String resBody, ILakalaApiDefinition merchantApiDefinitionEnum) {
        JSONObject resJson = JSONObject.parseObject((String)resBody);
        LakalaBizResponse bizResData = (LakalaBizResponse)resJson.getObject("respData", merchantApiDefinitionEnum.getResponseClass());
        resJson.remove((Object)"respData");
        LakalaBaseMerchantResponse response = (LakalaBaseMerchantResponse)resJson.toJavaObject(LakalaBaseMerchantResponse.class);
        response.setRespData(bizResData);
        return response;
    }

    static {
        LakalaUploadFileClientImpl.serializeConfig.propertyNamingStrategy = PropertyNamingStrategy.CamelCase;
    }
}

