/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package
        com.fshows.lakala.request.settle;

import com.fshows.lakala.enums.settle.LakalaSettleApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.settle.LakalaWithdrawApplyResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 账管家提现申请
 *
 * @author liluqing
 * @version LakalaWithdrawApplyRequest.java, v 0.1 2023-02-28 14:47
 */
@Data
public class LakalaWithdrawApplyRequest extends LakalaBizRequest<LakalaWithdrawApplyResponse, LakalaSettleApiDefinitionEnum> {

    private static final long serialVersionUID = -727852660595907292L;

    /**
     * bmcp机构号 (必填参数)
     * 示例：机构号
     */
    @NotBlank
    @Length(max = 32, message = "bmcp机构号长度不能超过32")
    private String orgNo;

    /**
     * 商户号 (必填参数)
     * 示例：822商户号，<br>SR分账接收方编号
     */
    @NotBlank
    @Length(max = 32, message = "商户号长度不能超过32")
    private String merchantNo;

    /**
     * 提现金额（单位：元） (必填参数)
     * 示例：
     */
    @NotBlank
    @Length(max = 32, message = "提现金额（单位：元）长度不能超过32")
    private String drawAmt;

    /**
     * 提款模式（D0-立即到账，D1-次日到账） 为空默认D1 (选填)
     * 示例：
     */
    @Length(max = 32, message = "提款模式（D0-立即到账，D1-次日到账） 为空默认D1长度不能超过32")
    private String drawMode;

    /**
     * 通知地址 (选填)
     * 示例：
     */
    @Length(max = 256, message = "通知地址长度不能超过256")
    private String notifyUrl;

    /**
     * 商户订单号（商户系统唯一） (选填)
     * 示例：
     */
    @Length(max = 256, message = "商户订单号（商户系统唯一）长度不能超过256")
    private String merOrderNo;

    /**
     * 账号（若该参数上送，则payType将无效） (选填)
     * 示例：
     */
    @Length(max = 32, message = "账号（若该参数上送，则payType将无效）长度不能超过32")
    private String payNo;

    /**
     * 账号类型（01：收款账户，04：分账接收方账户） <br> 未上送则默认为01 (选填)
     * 示例：分账接收方提现时需填04
     */
    @Length(max = 32, message = "账号类型（01：收款账户，04：分账接收方账户） <br> 未上送则默认为01长度不能超过32")
    private String payType;

    /**
     * 备注信息 (选填)
     * 示例：
     */
    @Length(max = 64, message = "备注信息长度不能超过64")
    private String remark;

    /**
     * 结算银行ID (选填)
     * 示例：
     */
    @Length(max = 32, message = "结算银行ID长度不能超过32")
    private String bankId;

}