/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.settle;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 分账完成请求 - 完成接收商终集合
 *
 * @author liluqing
 * @version LakalaSettleLedgerRevcDataRequest.java, v 0.1 2022-03-08 9:53
 */
@Data
public class LakalaSettleLedgerRevcDataRequest implements Serializable {

    private static final long serialVersionUID = 5832881927031332277L;

    /**
     * 完成接收商户号 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "完成接收商户号长度不能超过32")
    private String revcMerId;

    /**
     * 完成接收终端号 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "完成接收终端号长度不能超过32")
    private String revcTermId;

    /**
     * 完成百分比例 (选填)
     * 完成规则为1（按比例），该值必输
     */
    @Length(max = 8, message = "完成百分比例长度不能超过8")
    private String ledgerPercent;

    /**
     * 完成金额 (选填)
     * 单位分；完成规则为0（按金额），该值必输
     */
    @Length(max = 15, message = "完成金额长度不能超过15")
    private String txnAmt;
}