/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lakala.client.impl;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fshows.lakala.client.base.ApiClientConfig;
import com.fshows.lakala.client.base.IHttpRequest;
import com.fshows.lakala.client.base.ILakalaApiDefinition;
import com.fshows.lakala.client.base.ISigner;
import com.fshows.lakala.client.base.SignParam;
import com.fshows.lakala.client.impl.AbstractLakalaApiClientImpl;
import com.fshows.lakala.exception.LakalaApiException;
import com.fshows.lakala.request.base.LakalaBaseTradeRequest;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.base.LakalaBaseTradeResponse;
import com.fshows.lakala.response.base.LakalaBizResponse;
import com.fshows.lakala.util.LkalDateUtil;
import java.util.Date;

public class TradeLakalaApiClientImpl
extends AbstractLakalaApiClientImpl<LakalaBaseTradeRequest, LakalaBaseTradeResponse> {
    private static SerializeConfig SNAKE_CASE_CONFIG = new SerializeConfig();

    public TradeLakalaApiClientImpl(ApiClientConfig apiClientConfig) throws LakalaApiException {
        super(apiClientConfig);
    }

    public TradeLakalaApiClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws LakalaApiException {
        super(apiClientConfig, httpRequest, signer);
    }

    public <T extends LakalaBizResponse, R extends ILakalaApiDefinition> LakalaBaseTradeResponse<T> execute(LakalaBizRequest<T, R> request, R tradeApiDefinitionEnum) throws LakalaApiException {
        return (LakalaBaseTradeResponse)super.doExecute(request, tradeApiDefinitionEnum);
    }

    @Override
    protected LakalaBaseTradeRequest buildLakalaBizRequest(LakalaBizRequest bizRequest, ILakalaApiDefinition tradeApiDefinitionEnum) {
        LakalaBaseTradeRequest<LakalaBizRequest> request = new LakalaBaseTradeRequest<LakalaBizRequest>();
        request.setReqTime(new Date());
        request.setVersion(tradeApiDefinitionEnum.getVersion());
        request.setOutOrgCode(this.apiClientConfig.getAppId());
        request.setReqData(bizRequest);
        return request;
    }

    @Override
    protected SignParam buildSignParam(LakalaBaseTradeRequest lakalaBaseRequest, String bodyStr) {
        SignParam signParam = new SignParam();
        signParam.setAppid(this.apiClientConfig.getAppId());
        signParam.setSerialNo(this.apiClientConfig.getSerialNo());
        signParam.setBody(bodyStr);
        signParam.setNonceStr(RandomUtil.randomString((int)12));
        signParam.setTimeStamp(LkalDateUtil.formatToTimeStamp(lakalaBaseRequest.getReqTime()));
        return signParam;
    }

    @Override
    protected String serializableRequest(LakalaBaseTradeRequest lakalaBaseRequest, ILakalaApiDefinition tradeApiDefinitionEnum) {
        return JSONObject.toJSONString((Object)lakalaBaseRequest, (SerializeConfig)SNAKE_CASE_CONFIG, (SerializerFeature[])new SerializerFeature[0]);
    }

    @Override
    protected LakalaBaseTradeResponse parseResponse(String resBody, ILakalaApiDefinition tradeApiDefinitionEnum) {
        JSONObject resJson = JSONObject.parseObject((String)resBody);
        LakalaBizResponse bizResData = (LakalaBizResponse)resJson.getObject("resp_data", tradeApiDefinitionEnum.getResponseClass());
        resJson.remove((Object)"resp_data");
        LakalaBaseTradeResponse response = (LakalaBaseTradeResponse)resJson.toJavaObject(LakalaBaseTradeResponse.class);
        response.setRespData(bizResData);
        return response;
    }

    static {
        TradeLakalaApiClientImpl.SNAKE_CASE_CONFIG.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
    }
}

