/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lakala.client.impl;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.asymmetric.Sign;
import com.fshows.lakala.client.base.ApiClientConfig;
import com.fshows.lakala.client.base.ISigner;
import com.fshows.lakala.client.base.SignParam;
import com.fshows.lakala.client.base.VerifySignParam;
import com.fshows.lakala.exception.LakalaApiException;
import com.fshows.lakala.util.LogUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSignerImpl
implements ISigner {
    private static final Logger log = LoggerFactory.getLogger(DefaultSignerImpl.class);

    @Override
    public String sign(SignParam signParam, ApiClientConfig apiClientConfig) throws LakalaApiException {
        String signStr = this.doSign(signParam, apiClientConfig);
        String authorization = StrUtil.format((CharSequence)"LKLAPI-{} appid=\"{}\",serial_no=\"{}\",timestamp=\"{}\",nonce_str=\"{}\",signature=\"{}\"", (Object[])new Object[]{apiClientConfig.getSignTypeEnum().getAlgorithm(), signParam.getAppid(), signParam.getSerialNo(), signParam.getTimeStamp(), signParam.getNonceStr(), signStr});
        return authorization;
    }

    @Override
    public Boolean verifySign(String body, VerifySignParam verifySignParam, ApiClientConfig apiClientConfig) throws LakalaApiException {
        try {
            String waitSignStr = StrUtil.format((CharSequence)"{}\n{}\n{}\n{}\n{}\n", (Object[])new Object[]{verifySignParam.getAppid(), verifySignParam.getSerialNo(), verifySignParam.getTimeStamp(), verifySignParam.getNonceStr(), body});
            Sign sign = new Sign(apiClientConfig.getSignTypeEnum().getAlgorithm(), SecureUtil.decode((String)apiClientConfig.getFubeiPrivateKey()), SecureUtil.decode((String)apiClientConfig.getLakalaPublicKey()));
            return true;
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010lakala-sdk\u3011lakala\u54cd\u5e94\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25 >> signParam={}", e, verifySignParam);
            throw new LakalaApiException("lakala\u54cd\u5e94\u7ed3\u679c\u9a8c\u7b7e\u5931\u8d25", e);
        }
    }

    public String doSign(SignParam signParam, ApiClientConfig apiClientConfig) throws LakalaApiException {
        try {
            String waitSignStr = StrUtil.format((CharSequence)"{}\n{}\n{}\n{}\n{}\n", (Object[])new Object[]{signParam.getAppid(), signParam.getSerialNo(), signParam.getTimeStamp(), signParam.getNonceStr(), signParam.getBody()});
            Sign sign = new Sign(apiClientConfig.getSignTypeEnum().getAlgorithm(), SecureUtil.decode((String)apiClientConfig.getFubeiPrivateKey()), null);
            byte[] signed = sign.sign(waitSignStr.getBytes(apiClientConfig.getCharset()));
            return Base64.encode((byte[])signed);
        }
        catch (Exception e) {
            LogUtil.error(log, "\u3010lakala-sdk\u3011lakala\u8bf7\u6c42\u52a0\u7b7e\u5931\u8d25 >> signParam={}", e, signParam);
            throw new LakalaApiException("\u8bf7\u6c42\u52a0\u7b7e\u5931\u8d25", e);
        }
    }
}

