/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.settle;

import com.fshows.lakala.enums.settle.LakalaSettleApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.settle.LakalaSettleLedgerResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 拉卡拉分账完成请求
 *
 * @author liluqing
 * @version LakalaSettleLedgerRequest.java, v 0.1 2022-03-08 9:48
 */
@Data
public class LakalaSettleLedgerRequest extends LakalaBizRequest<LakalaSettleLedgerResponse, LakalaSettleApiDefinitionEnum> {

    private static final long serialVersionUID = 4505853843663881341L;

    /**
     * 交易日期 (必填参数)
     * 20201106
     */
    @NotBlank
    @Length(max = 8, message = "交易日期长度不能超过8")
    private String tranDate;

    /**
     * 交易时间 (必填参数)
     * 132455
     */
    @NotBlank
    @Length(max = 6, message = "交易时间长度不能超过6")
    private String tranTime;

    /**
     * 完成类型 (必填参数)
     * 01：完成，02：完成回退
     */
    @NotBlank
    @Length(max = 6, message = "完成类型长度不能超过6")
    private String ledgerType;

    /**
     * 机构号 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "机构号长度不能超过32")
    private String instId;

    /**
     * 拉卡拉订单日期 (选填)
     * 原交易订单日期，完成回退时不必输
     */
    @Length(max = 8, message = "拉卡拉订单日期长度不能超过8")
    private String logdat;

    /**
     * 拉卡拉订单流水号 (选填)
     */
    @Length(max = 32, message = "拉卡拉订单流水号长度不能超过32")
    private String logNo;

    /**
     * 完成总额 (必填参数)
     * 完成总金额
     */
    @NotBlank
    @Length(max = 15, message = "完成总额长度不能超过15")
    private String txnAmt;

    /**
     * 完成请求流水id (必填参数)
     * 完成发起方请求唯一标识
     */
    @NotBlank
    @Length(max = 32, message = "完成请求流水id长度不能超过32")
    private String ledgerTranSid;

    /**
     * 原完成请求流水id (必填参数)
     * 完成回退时必输
     */
    @NotBlank
    @Length(max = 32, message = "原完成请求流水id长度不能超过32")
    private String oledgerTranSid;

    /**
     * 完成发起商户号 (选填)
     * 完成回退时不必输
     */
    @Length(max = 32, message = "完成发起商户号长度不能超过32")
    private String sendMerId;

    /**
     * 完成发起终端号 (选填)
     * 完成回退时不必输
     */
    @Length(max = 32, message = "完成发起终端号长度不能超过32")
    private String sendTermId;

    /**
     * 业务类型 (必填参数)
     * 0：完成到本身，1：完成到多个人
     */
    @NotBlank
    @Length(max = 4, message = "业务类型长度不能超过4")
    private String busyType;

    /**
     * 完成规则 (必填参数)
     * 0：按照指定金额完成 1：按照比例完成
     */
    @NotBlank
    @Length(max = 2, message = "完成规则长度不能超过2")
    private String ruleType;

    /**
     * 完成接收商终集合 (必填参数)
     * revcData json 必输 完成接收商终 包含发起商户本身金额；按照比例会校验list所有数据比例之和是否为1；按照金额会校验list数据金额之和是否为完成总额
     */
    @NotNull
    private List<LakalaSettleLedgerRevcDataRequest> revcData;

    /**
     * 通知地址 (必填参数)
     * 通知用url
     */
    @NotNull
    @Length(max = 128, message = "通知地址长度不能超过128")
    private String notifyUrl;

    /**
     * 商户密钥 (必填参数)
     */
    @NotNull
    @Length(max = 512, message = "商户密钥长度不能超过512")
    private String merKey;

    /**
     * 验证码 (必填参数)
     * 清结算验证身份使用
     */
    @NotNull
    @Length(max = 512, message = "验证码长度不能超过512")
    private String verifycode;

}