/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.lakala.request.common;

import com.fshows.lakala.enums.merchant.LakalaMerchantApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.common.UploadPictureReponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author zhubo
 * @version UploadPictureRequest.java, v 0.1 2023-02-17 10:40 zhubo
 */
@Data
public class UploadPictureRequest extends LakalaBizRequest<UploadPictureReponse, LakalaMerchantApiDefinitionEnum> {

    private static final long serialVersionUID = 5047878558505286041L;

    /**
     * 接口版本号 (必填参数)
     */
    private String version;

    /**
     * 订单编号 (必填参数)
     */
    private String orderNo;

    /**
     * 机构代码 (必填参数)
     */
    private String orgCode;

    /**
     * 附件类型 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "附件类型长度不能超过32")
    private String attType;

    /**
     * 附件扩展名称 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "附件扩展名称长度不能超过32")
    private String attExtName;

    /**
     * 附件内容 (必填参数)
     */
    private byte[] attContext;
}
