/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lakala.client.impl;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.fshows.lakala.client.base.ApiClientConfig;
import com.fshows.lakala.client.base.IHttpRequest;
import com.fshows.lakala.client.base.ILakalaApiDefinition;
import com.fshows.lakala.client.base.ISigner;
import com.fshows.lakala.client.base.SignParam;
import com.fshows.lakala.client.impl.AbstractLakalaApiClientImpl;
import com.fshows.lakala.exception.LakalaApiException;
import com.fshows.lakala.request.base.LakalaBaseSettleRequest;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.base.LakalaBaseSettleResponse;
import com.fshows.lakala.response.base.LakalaBizResponse;
import com.fshows.lakala.util.ReqIdUtil;

public class SettleLakalaApiClientImpl
extends AbstractLakalaApiClientImpl<LakalaBaseSettleRequest, LakalaBaseSettleResponse> {
    private static SerializeConfig SNAKE_CASE_CONFIG = new SerializeConfig();

    public SettleLakalaApiClientImpl(ApiClientConfig apiClientConfig) throws LakalaApiException {
        super(apiClientConfig);
    }

    public SettleLakalaApiClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws LakalaApiException {
        super(apiClientConfig, httpRequest, signer);
    }

    public <T extends LakalaBizResponse, R extends ILakalaApiDefinition> LakalaBaseSettleResponse<T> execute(LakalaBizRequest<T, R> request, R settleApiDefinitionEnum) throws LakalaApiException {
        return (LakalaBaseSettleResponse)super.doExecute(request, settleApiDefinitionEnum);
    }

    @Override
    protected LakalaBaseSettleRequest buildLakalaBizRequest(LakalaBizRequest bizRequest, ILakalaApiDefinition settleApiDefinitionEnum) {
        LakalaBaseSettleRequest<LakalaBizRequest> request = new LakalaBaseSettleRequest<LakalaBizRequest>();
        request.setTimestamp(System.currentTimeMillis());
        request.setRnd(RandomUtil.randomString((int)12));
        request.setVer(settleApiDefinitionEnum.getVersion());
        request.setReqId(ReqIdUtil.getId());
        request.setReqData(bizRequest);
        return request;
    }

    @Override
    protected SignParam buildSignParam(LakalaBaseSettleRequest lakalaBaseRequest, String bodyStr) {
        SignParam signParam = new SignParam();
        signParam.setAppid(this.apiClientConfig.getAppId());
        signParam.setSerialNo(this.apiClientConfig.getSerialNo());
        signParam.setBody(bodyStr);
        signParam.setNonceStr(lakalaBaseRequest.getRnd());
        signParam.setTimeStamp(lakalaBaseRequest.getTimestamp() / 1000L);
        return signParam;
    }

    @Override
    protected String serializableRequest(LakalaBaseSettleRequest lakalaBaseRequest, ILakalaApiDefinition settleApiDefinitionEnum) {
        return JSONObject.toJSONString((Object)lakalaBaseRequest);
    }

    @Override
    protected LakalaBaseSettleResponse parseResponse(String resBody, ILakalaApiDefinition settleApiDefinitionEnum) {
        JSONObject resJson = JSONObject.parseObject((String)resBody);
        LakalaBizResponse bizResData = (LakalaBizResponse)resJson.getObject("respData", settleApiDefinitionEnum.getResponseClass());
        resJson.remove((Object)"respData");
        LakalaBaseSettleResponse response = (LakalaBaseSettleResponse)resJson.toJavaObject(LakalaBaseSettleResponse.class);
        response.setRespData(bizResData);
        return response;
    }

    static {
        SettleLakalaApiClientImpl.SNAKE_CASE_CONFIG.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
    }
}

