/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.response.trade.order;

import com.fshows.lakala.response.base.LakalaBizResponse;
import lombok.Data;

/**
 * 订单撤销响应结果
 *
 * @author liluqing
 * @version LakalaRevokeResponse.java, v 0.1 2022-03-07 14:00
 */
@Data
public class LakalaRevokeResponse extends LakalaBizResponse {

    private static final long serialVersionUID = 3705134809817762602L;

    /**
    * 商户号
    */
    private String merchantNo;
    /**
     * 商户请求流水号 (必填参数)
     * 请求中的商户请求流水号
     */
    private String outTradeNo;

    /**
     * 拉卡拉商户订单号 (选填)
     * 拉卡拉生成的交易流水
     */
    private String tradeNo;

    /**
     * 拉卡拉对账单流水号 (必填参数)
     * 拉卡拉对账单流水号
     */
    private String logNo;

    /**
     * 账户端交易订单号 (选填)
     * 账户端交易流水号
     */
    private String accTradeNo;

    /**
     * 钱包类型 (选填)
     * 微信：WECHAT 支付宝：ALIPAY 银联：UQRCODEPAY 翼支付: BESTPAY 苏宁易付宝: SUNING
     */
    private String accountType;

    /**
     * 交易金额 (必填参数)
     * 单位分，整数数字型字符串
     */
    private String totalAmount;

    /**
     * 交易完成时间 (必填参数)
     * 交易完成时间yyyyMMddHHmmss ,以账户方返回为准
     */
    private String tradeTime;

    /**
     * 原商户请求流水号 (选填)
     * 原商户请求流水号
     */
    private String originOutTradeNo;

    /**
     * 原拉卡拉交易流水号 (选填)
     * 原拉卡拉交易流水号
     */
    private String originTradeNo;

}