/**
 * fshows.com
 * Copyright (C) 2013-2023 All Rights Reserved.
 */
package com.fshows.lakala.response.merchant;

import com.fshows.lakala.response.base.LakalaBizResponse;
import lombok.Data;

/**
 * @author zhubo
 * @version LakalaQueryContractResponse.java, v 0.1 2023-02-16 15:27 zhubo
 */
@Data
public class LakalaQueryContractResponse extends LakalaBizResponse {

    private static final long serialVersionUID = -8614479807836883757L;

    /**
     * 机构代码
     */
    private String orgCode;

    /**
     * 订单号
     */
    private String orderNo;

    /**
     * 进件ID
     */
    private String contractId;

    /**
     * 进件状态
     * 提交失败：COMMIT_FAIL
     * 审核通过：WAIT_FOR_CONTACT
     * 审核驳回：INNER_CHECK_REJECTED
     */
    private String contractStatus;

    /**
     * 进件描述：进件审核通过，返回“审核通过”,进件审核驳回，返回具体的驳回理由
     */
    private String contractMemo;

    /**
     * 拉卡拉内部商户号
     */
    private String merInnerNo;

    /**
     * 银联商户号
     */
    private String merCupNo;

    /**
     * 终端列表信息
     */
    private String termDatas;

    /**
     * 网点编号
     */
    private String shopId;

    /**
     * 终端编号
     */
    private String termId;

    /**
     * 终端号
     */
    private String termNo;

    /**
     * 业务代码
     */
    private String busiTypeCode;

    /**
     * 业务名称
     */
    private String busiTypeName;

    /**
     * 产品名称
     */
    private String productName;

    /**
     * 产品代码
     */
    private String productCode;

    /**
     * 终端设备序列号
     */
    private String devSerialNo;
}
