/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.trade.pay;

import com.fshows.lakala.enums.trade.LakalaTradeApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.request.trade.pay.accbusifields.BaseAccBusiFieldsRequest;
import com.fshows.lakala.request.trade.pay.accbusifields.nucc.NuccPreOrderAccBusiRequest;
import com.fshows.lakala.response.trade.pay.LakalaPreOrderCreateResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 主扫下单（统一下单）业务参数
 *
 * @author liluqing
 * @version LakalaPreOrderCreateRequest.java, v 0.1 2022-03-01 22:16
 */
@Data
public class LakalaPreOrderCreateRequest extends LakalaBizRequest<LakalaPreOrderCreateResponse, LakalaTradeApiDefinitionEnum> {

    private static final long serialVersionUID = 5566349986771499109L;
    /**
     * 商户号 (必填参数)
     * 拉卡拉分配的商户号
     */
    @NotBlank
    @Length(max = 32, message = "商户号长度不能超过32")
    private String merchantNo;

    /**
     * 终端号 (必填参数)
     * 拉卡拉分配的业务终端号
     */
    @NotBlank
    @Length(max = 32, message = "终端号长度不能超过32")
    private String termNo;

    /**
     * 商户交易流水号 (必填参数)
     * 商户系统唯一，对应数据库表中外部请求流水号。
     */
    @NotBlank
    @Length(max = 32, message = "商户交易流水号长度不能超过32")
    private String outTradeNo;

    /**
     * 钱包类型 (必填参数)
     * 微信：WECHAT 支付宝：ALIPAY 银联：UQRCODEPAY 翼支付: BESTPAY 苏宁易付宝: SUNING 拉卡拉支付账户：LKLACC
     */
    @NotBlank
    @Length(max = 32, message = "钱包类型长度不能超过32")
    private String accountType;

    /**
     * 接入方式 (必填参数)
     * 41:NATIVE（扫码支付）（仅ALIPAY支持） <br>51:JSAPI（微信公众号支付，支付宝服务窗支付，银联JS支付，翼支付JS支付、拉卡拉钱包支付）<br>71:微信小程序支付
     */
    @NotBlank
    @Length(max = 2, message = "接入方式长度不能超过2")
    private String transType;

    /**
     * 金额 (必填参数)
     * 单位分，整数型字符
     */
    @NotBlank
    @Length(max = 12, message = "金额长度不能超过12")
    private String totalAmount;

    /**
     * 地址位置信息 (必填参数)
     * 地址位置信息，风控要求必送
     */
    @NotNull
    private LakalaLocationInfoRequest locationInfo;

    /**
     * 业务模式 (选填)
     * 业务模式： ACQ-收单 PAY-付款 不填，默认为“ACQ-收单”
     */
    @Length(max = 8, message = "业务模式长度不能超过8")
    private String busiMode;

    /**
     * 订单标题 (选填)
     * 标题，用于简单描述订单或商品主题，会传递给账户端 （账户端控制，实际最多42个字符），微信支付必送。
     */
    @Length(max = 42, message = "订单标题长度不能超过42")
    private String subject;

    /**
     * 支付业务订单号 (选填)
     * 拉卡拉订单系统订单号，以拉卡拉支付业务订单号为驱动的支付行为，需上传该字段。
     */
    @Length(max = 64, message = "支付业务订单号长度不能超过64")
    private String payOrderNo;

    /**
     * 商户通知地址 (选填)
     * 商户通知地址，如果上传，且 pay_order_no 不存在情况下，则按此地址通知商户(详见“[<a href="http://106.14.112.9:5000/wiki/docs/openplatform/openplatform-1d7eqngmcl0g8" target="_blank" title="订单通知">交易通知</a>]”接口)
     */
    @Length(max = 128, message = "商户通知地址长度不能超过128")
    private String notifyUrl;

    /**
     * 结算类型 (选填)
     * “0”或者空，常规结算方式；
     */
    @Length(max = 4, message = "结算类型长度不能超过4")
    private String settleType;

    /**
     * 备注 (选填)
     */
    @Length(max = 128, message = "备注长度不能超过128")
    private String remark;

    /**
     * 身份信息 (选填)
     * 实名支付信息，json字符串，如{“identityNo”:”32000000000000000X”,”name”:”张三”} ，然后国密sm2加密
     */
    @Length(max = 1024, message = "身份信息长度不能超过1024")
    private String identityInfo;

    /**
     * 优惠信息 (选填)
     * 优惠相关信息，JSON格式
     */
    @Length(max = 1024, message = "优惠信息长度不能超过1024")
    private String promoInfo;

    /**
     * 账户端业务信息域 (选填)
     * 参见以下acc_busi_fields字段详细说明,不同的account_type和trans_type，需要传入的参数不一样
     *
     * @see com.fshows.lakala.request.trade.pay.accbusifields.alipay.AlipayPreOrderAccBusiRequest
     * @see com.fshows.lakala.request.trade.pay.accbusifields.wx.WxPreOrderAccBusiRequest
     * @see com.fshows.lakala.request.trade.pay.accbusifields.union.UnionPreOrderAccBusiRequest
     * @see com.fshows.lakala.request.trade.pay.accbusifields.nucc.NuccPreOrderAccBusiRequest
     */
    private BaseAccBusiFieldsRequest accBusiFields;
}