/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.client.impl;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.fshows.lakala.client.base.ApiClientConfig;
import com.fshows.lakala.client.base.IHttpRequest;
import com.fshows.lakala.client.base.ILakalaApiDefinition;
import com.fshows.lakala.client.base.ISigner;
import com.fshows.lakala.client.base.SignParam;
import com.fshows.lakala.constant.LakalaConstant;
import com.fshows.lakala.exception.LakalaApiException;
import com.fshows.lakala.request.base.LakalaBaseTradeRequest;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.base.LakalaBaseTradeResponse;
import com.fshows.lakala.response.base.LakalaBizResponse;
import com.fshows.lakala.util.LkalDateUtil;

import java.util.Date;

/**
 * 拉卡拉交易接口客户端
 *
 * @author liluqing
 * @version TradeLakalaApiClientImpl.java, v 0.1 2022-03-04 15:02
 */
public class TradeLakalaApiClientImpl extends AbstractLakalaApiClientImpl<LakalaBaseTradeRequest, LakalaBaseTradeResponse> {

    private static SerializeConfig SNAKE_CASE_CONFIG = new SerializeConfig();

    static {
        SNAKE_CASE_CONFIG.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
    }

    public TradeLakalaApiClientImpl(ApiClientConfig apiClientConfig) throws LakalaApiException {
        super(apiClientConfig);
    }

    public TradeLakalaApiClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws LakalaApiException {
        super(apiClientConfig, httpRequest, signer);
    }

    @Override
    public <T extends LakalaBizResponse, R extends ILakalaApiDefinition> LakalaBaseTradeResponse<T> execute(LakalaBizRequest<T, R> request, R tradeApiDefinitionEnum) throws LakalaApiException {
        return super.doExecute(request, tradeApiDefinitionEnum);
    }

    /**
     * 添加公共参数构建完整的请求
     *
     * @param bizRequest 业务请求参数
     * @param tradeApiDefinitionEnum
     * @return
     */
    @Override
    protected LakalaBaseTradeRequest buildLakalaBizRequest(LakalaBizRequest bizRequest, ILakalaApiDefinition tradeApiDefinitionEnum) {
        LakalaBaseTradeRequest request = new LakalaBaseTradeRequest();
        request.setReqTime(new Date());
        request.setVersion(tradeApiDefinitionEnum.getVersion());
        request.setOutOrgCode(apiClientConfig.getAppId());
        request.setReqData(bizRequest);
        return request;
    }

    @Override
    protected SignParam buildSignParam(LakalaBaseTradeRequest lakalaBaseRequest, String bodyStr) {
        SignParam signParam = new SignParam();
        signParam.setAppid(apiClientConfig.getAppId());
        signParam.setSerialNo(apiClientConfig.getSerialNo());
        signParam.setBody(bodyStr);
        signParam.setNonceStr(RandomUtil.randomString(12));
        signParam.setTimeStamp(LkalDateUtil.formatToTimeStamp(lakalaBaseRequest.getReqTime()));
        return signParam;
    }

    @Override
    protected String serializableRequest(LakalaBaseTradeRequest lakalaBaseRequest, ILakalaApiDefinition tradeApiDefinitionEnum) {
        return JSONObject.toJSONString(lakalaBaseRequest, SNAKE_CASE_CONFIG);
    }

    @Override
    protected LakalaBaseTradeResponse parseResponse(String resBody, ILakalaApiDefinition tradeApiDefinitionEnum) {
        JSONObject resJson = JSONObject.parseObject(resBody);

        // 业务响应结果
        LakalaBizResponse bizResData = (LakalaBizResponse) resJson.getObject(LakalaConstant.LAKALA_RESPONSE_BIZ_KEY, tradeApiDefinitionEnum.getResponseClass());
        resJson.remove(LakalaConstant.LAKALA_RESPONSE_BIZ_KEY);

        // 完整响应结果
        LakalaBaseTradeResponse response = resJson.toJavaObject(LakalaBaseTradeResponse.class);
        response.setRespData(bizResData);
        return response;
    }
}