/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.lakala.client.impl;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fshows.lakala.client.base.ApiClientConfig;
import com.fshows.lakala.client.base.IHttpRequest;
import com.fshows.lakala.client.base.ILakalaApiDefinition;
import com.fshows.lakala.client.base.ISigner;
import com.fshows.lakala.client.base.SignParam;
import com.fshows.lakala.client.impl.AbstractLakalaApiClientImpl;
import com.fshows.lakala.exception.LakalaApiException;
import com.fshows.lakala.request.base.LakalaBaseMerchantRequest;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.base.LakalaBaseMerchantResponse;
import com.fshows.lakala.response.base.LakalaBizResponse;
import com.fshows.lakala.util.ReqIdUtil;

public class MerchantLakalaApiClientImpl
extends AbstractLakalaApiClientImpl<LakalaBaseMerchantRequest, LakalaBaseMerchantResponse> {
    private static SerializeConfig SNAKE_CASE_CONFIG = new SerializeConfig();

    public MerchantLakalaApiClientImpl(ApiClientConfig apiClientConfig) throws LakalaApiException {
        super(apiClientConfig);
    }

    public MerchantLakalaApiClientImpl(ApiClientConfig apiClientConfig, IHttpRequest httpRequest, ISigner signer) throws LakalaApiException {
        super(apiClientConfig, httpRequest, signer);
    }

    public <T extends LakalaBizResponse, R extends ILakalaApiDefinition> LakalaBaseMerchantResponse<T> execute(LakalaBizRequest<T, R> request, R merchantApiDefinitionEnum) throws LakalaApiException {
        return (LakalaBaseMerchantResponse)super.doExecute(request, merchantApiDefinitionEnum);
    }

    @Override
    protected LakalaBaseMerchantRequest buildLakalaBizRequest(LakalaBizRequest bizRequest, ILakalaApiDefinition merchantApiDefinitionEnum) {
        LakalaBaseMerchantRequest<LakalaBizRequest> request = new LakalaBaseMerchantRequest<LakalaBizRequest>();
        request.setTimestamp(System.currentTimeMillis());
        request.setRnd(RandomUtil.randomString((int)12));
        request.setVer(merchantApiDefinitionEnum.getVersion());
        request.setReqId(ReqIdUtil.getId());
        request.setReqData(bizRequest);
        return request;
    }

    @Override
    protected SignParam buildSignParam(LakalaBaseMerchantRequest lakalaBaseRequest, String bodyStr) {
        SignParam signParam = new SignParam();
        signParam.setAppid(this.apiClientConfig.getAppId());
        signParam.setSerialNo(this.apiClientConfig.getSerialNo());
        signParam.setBody(bodyStr);
        signParam.setNonceStr(lakalaBaseRequest.getRnd());
        signParam.setTimeStamp(lakalaBaseRequest.getTimestamp() / 1000L);
        return signParam;
    }

    @Override
    protected String serializableRequest(LakalaBaseMerchantRequest lakalaBaseRequest, ILakalaApiDefinition merchantApiDefinitionEnum) {
        return JSONObject.toJSONString((Object)lakalaBaseRequest, (SerializeConfig)SNAKE_CASE_CONFIG, (SerializerFeature[])new SerializerFeature[0]);
    }

    @Override
    protected LakalaBaseMerchantResponse parseResponse(String resBody, ILakalaApiDefinition merchantApiDefinitionEnum) {
        JSONObject resJson = JSONObject.parseObject((String)resBody);
        LakalaBizResponse bizResData = (LakalaBizResponse)resJson.getObject("resp_data", merchantApiDefinitionEnum.getResponseClass());
        resJson.remove((Object)"resp_data");
        LakalaBaseMerchantResponse response = (LakalaBaseMerchantResponse)resJson.toJavaObject(LakalaBaseMerchantResponse.class);
        response.setRespData(bizResData);
        return response;
    }

    static {
        MerchantLakalaApiClientImpl.SNAKE_CASE_CONFIG.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
    }
}

