/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.response.base;

import com.fshows.lakala.enums.trade.LakalaTradeResponseCodeEnum;
import lombok.Data;

/**
 * 交易相关响应基类
 *
 * @author liluqing
 * @version LakalaBaseResponse.java, v 0.1 2022-03-02 11:27
 */
@Data
public class LakalaBaseTradeResponse<E extends LakalaBizResponse> extends LakalaBaseResponse  {

    private static final long serialVersionUID = -5749849354769433484L;
    /**
     * 返回业务代码
     *
     * @see LakalaTradeResponseCodeEnum
     */
    private String code;

    /**
     * 返回业务代码描述
     */
    private String msg;

    /**
     * 响应时间,格式yyyyMMddHHmmss
     */
    private String respTime;

    /**
     * 响应数据
     */
    private E respData;

    @Override
    public boolean isSuccess() {
        return LakalaTradeResponseCodeEnum.SUCCESS.getValue().equals(this.getCode());
    }
}