/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.response.base;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.lakala.enums.merchant.LakalaMerchantResponseCodeEnum;
import lombok.Data;

/**
 * 商户进件相关接口请求基类
 *
 * @author liluqing
 * @version LakalaBaseMerchantResponse.java, v 0.1 2022-03-02 11:27
 */
@Data
public class LakalaBaseMerchantResponse<E extends LakalaBizResponse> extends LakalaBaseResponse {

    private static final long serialVersionUID = -4801629322517625734L;
    /**
     * 返回业务代码
     *
     * @see LakalaMerchantResponseCodeEnum
     */
    private String retCode;

    /**
     * 返回业务代码描述
     */
    private String retMsg;

    /**
     * Unix时间戳(毫秒)，13位
     */
    private Long timestamp;

    /**
     * 随机数
     */
    private String rnd;

    /**
     * 请求序列号
     */
    private String reqId;

    /**
     * 响应序列号
     */
    private String respId;

    /**
     * 版本号
     */
    private String ver;

    /**
     * 响应数据
     */
    private E respData;

    @JSONField(serialize = false)
    @Override
    public String getCode() {
        return this.retCode;
    }

    @JSONField(serialize = false)
    @Override
    public String getMsg() {
        return this.retMsg;
    }

    @JSONField(serialize = false)
    @Override
    public boolean isSuccess() {
        return LakalaMerchantResponseCodeEnum.SUCCESS.getValue().equals(this.getCode());
    }
}