/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.trade.pay.accbusifields.alipay;

import com.fshows.lakala.request.trade.pay.accbusifields.BaseAccBusiFieldsRequest;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 支付宝主扫场景下acc_busi_fields域内容
 *
 * @author liluqing
 * @version AlipayPreOrderAccBusiRequest.java, v 0.1 2022-03-07 11:46
 */
@Data
public class AlipayPreOrderAccBusiRequest extends BaseAccBusiFieldsRequest {

    private static final long serialVersionUID = -3303455990419343973L;
    /**
     * 买家在支付宝的用户id (必填参数)
     * 支付宝的buyer_user_id
     */
    @NotBlank
    @Length(max = 64, message = "买家在支付宝的用户id长度不能超过64")
    private String userId;

    /**
     * 预下单有效时间 (选填)
     * 预下单的订单的有效时间，以分钟为单位。如果在有效时间内没有完成付款，则在账户端该订单失效。如果不上送，以账户端订单失效时间为准。 建议不超过15分钟。不传值则默认5分钟。
     */
    @Length(max = 2, message = "预下单有效时间长度不能超过2")
    private String timeoutExpress;

    /**
     * 业务扩展参数 (选填)
     * 支付宝业务扩展参数 ，见说明
     *
     * @see AlipayExtendParamsRequest
     */
    private AlipayExtendParamsRequest extendParams;

    /**
     * 商品详情 (选填)
     * 订单包含的商品列表信息，Json格式。
     */
    @Length(max = 6000, message = "商品详情长度不能超过6000")
    private String goodsDetail;

    /**
     * 用户付款中途退出返回商户网站的地址 (选填)
     * transType=81时（即支付宝H5支付），此参数必传
     */
    @Length(max = 256, message = "用户付款中途退出返回商户网站的地址长度不能超过256")
    private String quitUrl;

    /**
     * 支付宝的店铺编号 (选填)
     */
    @Length(max = 32, message = "支付宝的店铺编号长度不能超过32")
    private String alipayStoreId;

    /**
     * 支付宝禁用支付渠道 (选填)
     * “credit_group”表示禁用信用卡
     */
    @Length(max = 32, message = "支付宝禁用支付渠道长度不能超过32")
    private String disablePayChannels;
}