/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package
        com.fshows.lakala.request.merchant;

import com.fshows.lakala.enums.merchant.LakalaMerchantApiDefinitionEnum;
import com.fshows.lakala.request.base.LakalaBizRequest;
import com.fshows.lakala.response.settle.LakalaSettleQueryAcctInfoResponse;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.List;
import java.util.Set;

/**
 * 商户进价
 *
 * @author liluqing
 * @version LakalaAddMerchantRequest.java, v 0.1 2022-03-08 15:48
 */
@Data
public class LakalaAddMerchantRequest extends LakalaBizRequest<LakalaSettleQueryAcctInfoResponse, LakalaMerchantApiDefinitionEnum> {

    private static final long serialVersionUID = 8441206421249264084L;

    /**
     * 接口版本号 (必填参数)
     * 1.0
     */
    @NotBlank
    @Length(max = 8, message = "接口版本号长度不能超过8")
    private String version;

    /**
     * 订单编号（便于后续跟踪排查问题及核对报文） (必填参数)
     * 14位年月日时（24小时制）分秒+8位的随机数（不重复）如：2021020112000012345678
     */
    @NotBlank
    @Length(max = 32, message = "订单编号长度不能超过32")
    private String orderNo;

    /**
     * 进件POS类型 —按接入系统做控制，参见【<a href="http://106.14.112.9:5000/wiki/docs/openplatform/openplatform-1cqhrofc5vcqt" target="_blank" title="POS类型字典表">POS类型字典表</a>】 (必填参数)
     * GENERAL_POS
     */
    @NotBlank
    @Length(max = 32, message = "进件POS类型长度不能超过32")
    private String posType;

    /**
     * 机构代码 （合作方在拉卡拉的标识，请联系业务员） (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "机构代码长度不能超过32")
    private String orgCode;

    /**
     * 商户注册名称 (必填参数)
     * 长度不小于7个汉字；营业执照商户可填营业执照名称，小微商户入网不得含有“有限公司”。【14~80字符，不可为纯数字】
     */
    @NotBlank
    @Length(max = 80, message = "商户注册名称长度不能超过80")
    private String merRegName;

    /**
     * 商户经营名称 (选填)
     * 为空时，同商户注册名称，4-80个字符 【4~80字符，不可为纯数字】
     */
    @Length(max = 80, message = "商户经营名称长度不能超过80")
    private String merBizName;

    /**
     * 商户地区代码 (必填参数)
     * 地区代码，<a href="http://106.14.112.9:5000/wiki/docs/openplatform/openplatform-1cppd63hpj6hf" target="_blank" title="参看地区文档">参看地区文档</a>]
     */
    @NotBlank
    @Length(max = 8, message = "商户地区代码长度不能超过8")
    private String merRegDistCode;

    /**
     * 商户详细地址 (必填参数)
     * 去除省，市，区后的详细地址，6-200字符
     */
    @NotBlank
    @Length(max = 80, message = "商户详细地址长度不能超过80")
    private String merRegAddr;

    /**
     * 商户MCC编号 (必填参数)
     * 银联商户类别代码，参见【<a href="http://106.14.112.9:5000/wiki/docs/openplatform/openplatform-1d6hnr82a8eqa" target="_blank" title="MCC对照表">MCC对照表</a>】
     */
    @NotBlank
    @Length(max = 8, message = "商户MCC编号长度不能超过8")
    private String mccCode;

    /**
     * 营业执照名称 (选填)
     * 小微商户可不传，其它必传
     */
    @Length(max = 80, message = "营业执照名称长度不能超过80")
    private String merBlisName;

    /**
     * 营业执照号 (选填)
     * 小微商户可不传，对公进件必传，且不可与法人证件相同
     */
    @Length(max = 40, message = "营业执照号长度不能超过40")
    private String merBlis;

    /**
     * 营业执照开始日期 (选填)
     * 格式（yyyy-MM-dd）有营业执照时必传，否则微信实名认证会失败
     */
    @Length(max = 10, message = "营业执照开始日期长度不能超过10")
    private String merBlisStDt;

    /**
     * 营业执照有效期 (选填)
     * 格式（yyyy-MM-dd）有营业执照时必传，否则微信实名认证会失败
     */
    @Length(max = 10, message = "营业执照有效期长度不能超过10")
    private String merBlisExpDt;

    /**
     * 商户经营内容 (必填参数)
     * 参看【<a href="http://106.14.112.9:5000/wiki/docs/openplatform/openplatform-1cppdrq2dlqen" target="_blank" title="经营内容字典表">经营内容字典表</a>】文档
     */
    @NotBlank
    @Length(max = 64, message = "商户经营内容长度不能超过64")
    private String merBusiContent;

    /**
     * 商户法人姓名 (必填参数)
     */
    @NotBlank
    @Length(max = 20, message = "商户法人姓名长度不能超过20")
    private String larName;

    /**
     * 法人证件类型 (必填参数)
     * 支持其他证件类型，见参【<a href="http://106.14.112.9:5000/wiki/docs/openplatform/openplatform-1cqhu9a2175la" target="_blank" title="证件类型字典表">证件类型字典表</a>】
     */
    @NotBlank
    @Length(max = 8, message = "法人证件类型长度不能超过8")
    private String larIdType;

    /**
     * 法人身份证号码 (必填参数)
     */
    @NotBlank
    @Length(max = 40, message = "法人身份证号码长度不能超过40")
    private String larIdcard;

    /**
     * 法人身份证开始日期 yyyy-MM-dd (必填参数)
     */
    @NotBlank
    @Length(max = 10, message = "法人身份证开始日期长度不能超过10")
    private String larIdcardStDt;

    /**
     * 法人身份证有效期 yyyy-MM-dd (必填参数)
     */
    @NotBlank
    @Length(max = 10, message = "法人身份证有效期长度不能超过10")
    private String larIdcardExpDt;

    /**
     * 商户联系人手机号码 (必填参数)
     */
    @NotBlank
    @Length(max = 20, message = "商户联系人手机号码长度不能超过20")
    private String merContactMobile;

    /**
     * 商户联系人 (必填参数)
     */
    @NotBlank
    @Length(max = 32, message = "商户联系人长度不能超过32")
    private String merContactName;

    /**
     * 网点名称 (选填)
     * 不填，取商户注册名称
     */
    @Length(max = 80, message = "网点名称长度不能超过80")
    private String shopName;

    /**
     * 网点地址区划代码 (选填)
     * 不填，取商户地区代码
     */
    @Length(max = 8, message = "网点地址区划代码长度不能超过8")
    private String shopDistCode;

    /**
     * 网点详细地址 (选填)
     * 不填，取商户详细地址
     */
    @Length(max = 80, message = "网点详细地址长度不能超过80")
    private String shopAddr;

    /**
     * 网点联系人名称 (选填)
     * 不填，取商户联系人姓名
     */
    @Length(max = 32, message = "网点联系人名称长度不能超过32")
    private String shopContactName;

    /**
     * 网点联系人手机号 (选填)
     * 不填，取商户联系人手机号码
     */
    @Length(max = 20, message = "网点联系人手机号长度不能超过20")
    private String shopContactMobile;

    /**
     * 结算账户开户行号 (必填参数)
     * 可根据结算卡信息进行查询，参见【<a href="http://106.14.112.9:5000/wiki/docs/openplatform/openplatform-1cqhtgji52lb8" target="_blank" title="卡BIN信息查询">卡BIN信息查询</a>】
     */
    @NotBlank
    @Length(max = 20, message = "结算账户开户行号长度不能超过20")
    private String openningBankCode;

    /**
     * 结算账户开户行名称 (必填参数)
     * 可根据结算卡信息进行查询，参见【<a href="http://106.14.112.9:5000/wiki/docs/openplatform/openplatform-1cqhtgji52lb8" target="_blank" title="卡BIN信息查询">卡BIN信息查询</a>】
     */
    @NotBlank
    @Length(max = 40, message = "结算账户开户行名称长度不能超过40")
    private String openningBankName;

    /**
     * 结算账户清算行号 (必填参数)
     * 可根据结算卡信息进行查询，参见【<a href="http://106.14.112.9:5000/wiki/docs/openplatform/openplatform-1cqhtgji52lb8" target="_blank" title="卡BIN信息查询">卡BIN信息查询</a>】
     */
    @NotBlank
    @Length(max = 20, message = "结算账户清算行号长度不能超过20")
    private String clearingBankCode;

    /**
     * 结算账户账号 (必填参数)
     */
    @NotBlank
    @Length(max = 40, message = "结算账户账号长度不能超过40")
    private String acctNo;

    /**
     * 结算账户名称 (必填参数)
     */
    @NotBlank
    @Length(max = 40, message = "结算账户名称长度不能超过40")
    private String acctName;

    /**
     * 结算账户性质 (必填参数)
     * 57 对公<br>58 对私
     */
    @NotBlank
    @Length(max = 8, message = "结算账户性质长度不能超过8")
    private String acctTypeCode;

    /**
     * 结算周期 (必填参数)
     * 参见【<a href="http://106.14.112.9:5000/wiki/docs/openplatform/openplatform-1cqhu1vnprh6q" target="_blank" title="结算周期表">结算周期表</a>】
     */
    @NotBlank
    @Length(max = 8, message = "结算周期长度不能超过8")
    private String settlePeriod;

    /**
     * 日切时间 (选填)
     * 参考【<a href="http://106.14.112.9:5000/wiki/docs/openplatform/openplatform-1d10s3ujtdcm3" target="_blank" title="日切时间字典表">日切时间字典表</a>】文档，默认 TWENTY_THRE
     */
    @Length(max = 16, message = "日切时间长度不能超过16")
    private String clearDt;

    /**
     * 结算人证件类型 (选填)
     * 为空时，判断为同法人
     */
    @Length(max = 8, message = "结算人证件类型长度不能超过8")
    private String acctIdType;

    /**
     * 结算人证件号码 (选填)
     * 为空时，判断为同法人
     */
    @Length(max = 40, message = "结算人证件号码长度不能超过40")
    private String acctIdcard;

    /**
     * 结算人证件有效期 (选填)
     * 为空时，判断为同法人
     */
    @Length(max = 10, message = "结算人证件有效期长度不能超过10")
    private String acctIdDt;

    /**
     * 终端设备序列号 (选填)
     */
    @Length(max = 64, message = "终端设备序列号长度不能超过64")
    private String devSerialNo;

    /**
     * 设备型号 (选填)
     */
    @Length(max = 32, message = "设备型号长度不能超过32")
    private String devTypeName;

    /**
     * 终端版本号 (选填)
     */
    @Length(max = 32, message = "终端版本号长度不能超过32")
    private String termVer;

    /**
     * 终端数量（1-5） 最大5个终端 (选填)
     */
    @Length(max = 8, message = "终端数量（1-5） 最大5个终端长度不能超过8")
    private String termNum;

    /**
     * 回调地址 (必填参数)
     * url
     */
    @NotBlank
    @Length(max = 64, message = "回调地址长度不能超过64")
    private String retUrl;

    /**
     * 费率信息集合 (必填参数)
     * 参看下方【费率信息】
     */
    @NotNull
    private Set<LakalaFeeRateRequest> feeData;

    /**
     * 附件信息集合 (选填)
     */
    private Set<LakalaFileDataRequest> fileData;

    /**
     * 电子合同编号 (选填)
     * 部分进件类型要求录入
     */
    private String contractNo;

}