package com.fshows.lakala.enums.settle;

import com.fshows.lakala.client.base.ILakalaApiDefinition;
import com.fshows.lakala.constant.LakalaConstant;
import com.fshows.lakala.request.settle.LakalaSettleLedgerRequest;
import com.fshows.lakala.request.settle.LakalaSettleQueryAcctInfoRequest;
import com.fshows.lakala.request.settle.LakalaSettleResultQueryRequest;
import com.fshows.lakala.response.settle.LakalaSettleLedgerResponse;
import com.fshows.lakala.response.settle.LakalaSettleQueryAcctInfoResponse;

/**
 * 拉卡拉结算相关API
 *
 * @author liluqing
 * @version LakalaSettleApiDefinitionEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum LakalaSettleApiDefinitionEnum implements ILakalaApiDefinition {
    SETTLE_LEDGER(
            "分账完成请求",
            "mrss/ledger/settle_ledger",
            LakalaConstant.SETTLE_API_VERSION_V1,
            LakalaSettleLedgerRequest.class,
            LakalaSettleLedgerResponse.class
    ),
    SETTLE_RESULT_QUERY(
            "结算结果查询",
            "mrss/ledger/settle_result_query",
            LakalaConstant.SETTLE_API_VERSION_V1,
            LakalaSettleResultQueryRequest.class,
            LakalaSettleResultQueryRequest.class
    ),
    QUERY_ACCT_INFO(
            "商户账户余额查询",
            "mrss/query/queryAcctInfo",
            LakalaConstant.SETTLE_API_VERSION_V1,
            LakalaSettleQueryAcctInfoRequest.class,
            LakalaSettleQueryAcctInfoResponse.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 接口版本号
     */
    private String version;
    /**
     * 请求Class类型
     */
    private Class requestClass;
    /**
     * 响应Class类型
     */
    private Class responseClass;


    LakalaSettleApiDefinitionEnum(String name,
                                  String apiSubURI,
                                  String version,
                                  Class requestClass,
                                  Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiSubURI() {
        return apiSubURI;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}