package com.fshows.lakala.enums.merchant;

import com.fshows.lakala.client.base.ILakalaApiDefinition;
import com.fshows.lakala.constant.LakalaConstant;
import com.fshows.lakala.request.merchant.LakalaAddMerchantRequest;
import com.fshows.lakala.request.merchant.LakalaAddTermRequest;
import com.fshows.lakala.request.merchant.LakalaChangeMerchantRequest;
import com.fshows.lakala.response.merchant.LakalaAddMerchantResponse;
import com.fshows.lakala.response.merchant.LakalaAddTermResponse;
import com.fshows.lakala.response.merchant.LakalaChangeMerchantResponse;

/**
 * 拉卡拉商户进件入驻相关API
 *
 * @author liluqing
 * @version LakalaMerchantApiDefinitionEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum LakalaMerchantApiDefinitionEnum implements ILakalaApiDefinition {
    ADD_MERCHANT(
            "商户入驻接口",
            "api/v2/mms/openApi/addMer",
            LakalaConstant.MERCHANT_API_VERSION_V2,
            LakalaAddMerchantRequest.class,
            LakalaAddMerchantResponse.class
    ),
    ADD_TERM(
            "增网增终进件",
            "api/v2/mms/openApi/addTerm",
            LakalaConstant.MERCHANT_API_VERSION_V2,
            LakalaAddTermRequest.class,
            LakalaAddTermResponse.class
    ),
    CHANGE_MERCHANT(
            "商户信息变更",
            "api/v2/mms/openApi/changeMer",
            LakalaConstant.MERCHANT_API_VERSION_V2,
            LakalaChangeMerchantRequest.class,
            LakalaChangeMerchantResponse.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 接口版本号
     */
    private String version;
    /**
     * 请求Class类型
     */
    private Class requestClass;
    /**
     * 响应Class类型
     */
    private Class responseClass;


    LakalaMerchantApiDefinitionEnum(String name,
                                    String apiSubURI,
                                    String version,
                                    Class requestClass,
                                    Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiSubURI() {
        return apiSubURI;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}