/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.kqbill.request.trade;

import com.fshows.kqbill.request.KqbillBizReq;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author wangqilei
 * @version KqbillTradeQueryReq.java, v 0.1 2024-07-03 5:06 PM wangqilei
 */
@Data
public class KqbillOrderStatusQueryReq extends KqbillBizReq {
    /**
     * 商户在快钱的唯一标识
     */
    @NotBlank
    @Length(max = 15, message = "merchantId长度不能超过15")
    private String merchantId;

    /**
     * 快钱分配给商户的终端编号
     * (必填)
     */
    @NotBlank
    @Length(max = 15, message = "terminalId长度不能超过15")
    private String terminalId;
}