/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.kqbill.util;

import com.fshows.kqbill.handler.KqbillClientConfigModel;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FsHttpSslRequest {
    private static final Logger log = LoggerFactory.getLogger(FsHttpSslRequest.class);
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_GET = "GET";
    private static final int DEFAULT_READ_TIMEOUT = 10000;
    private static final int DEFAULT_CONNECTION_TIMEOUT = 3000;
    private static final String DEFAULT_CONTENT_TYPE = "application/x-www-form-urlencoded;charset=utf-8";
    private static final String JSON_CONTENT_TYPE = "application/json;charset=utf-8";
    private HostnameVerifier verifier = null;
    private SSLSocketFactory socketFactory = null;
    private KeyStore keyStore = null;
    private SSLContext sslContext = null;

    public FsHttpSslRequest(KqbillClientConfigModel kqbillClientConfigModel) {
        try {
            this.keyStore = KeyStore.getInstance(kqbillClientConfigModel.getSSLKeyStore());
            try (FileInputStream fis = new FileInputStream(kqbillClientConfigModel.getSSLCertPath());){
                this.keyStore.load(fis, kqbillClientConfigModel.getSSLKeyPass().toCharArray());
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(this.keyStore, kqbillClientConfigModel.getSSLKeyPass().toCharArray());
            this.sslContext = SSLContext.getInstance(kqbillClientConfigModel.getSSLVersion());
            this.sslContext.init(kmf.getKeyManagers(), new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            this.sslContext.getClientSessionContext().setSessionTimeout(15);
            this.sslContext.getClientSessionContext().setSessionCacheSize(1000);
            this.socketFactory = this.sslContext.getSocketFactory();
        }
        catch (Exception ignored) {
            log.error("\u5feb\u94b1\u8bc1\u4e66\u52a0\u8f7d\u5931\u8d25 >> kqbillClientConfigModel=" + (Object)((Object)kqbillClientConfigModel), (Throwable)ignored);
            throw new RuntimeException("\u5feb\u94b1\u8bc1\u4e66\u52a0\u8f7d\u5931\u8d25");
        }
        this.verifier = (hostname, session) -> true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String post(String url, Map<String, String> params, String charset, String contentType, int connectTimeout, int readTimeout, Map<String, String> headers) throws IOException {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new IllegalArgumentException("url is empty");
        }
        if (StringUtils.isBlank((CharSequence)charset)) {
            charset = DEFAULT_CHARSET;
        }
        if (StringUtils.isBlank((CharSequence)contentType)) {
            contentType = DEFAULT_CONTENT_TYPE;
        }
        if (connectTimeout <= 0) {
            connectTimeout = 3000;
        }
        if (readTimeout <= 0) {
            readTimeout = 10000;
        }
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        String query = this.buildQuery(params, charset);
        byte[] content = new byte[]{};
        if (StringUtils.isNotBlank((CharSequence)query)) {
            content = query.getBytes(charset);
        }
        long startTime = System.currentTimeMillis();
        try {
            conn = this.getConnection(new URL(url), METHOD_POST, contentType, headers);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            out = conn.getOutputStream();
            log.info("fshttp >> \u521b\u5efahttp\u8fde\u63a5\u8017\u65f6 >> {}ms", (Object)(System.currentTimeMillis() - startTime));
            startTime = System.currentTimeMillis();
            out.write(content);
            log.info("fshttp >> \u53d1\u9001\u8bf7\u6c42\u8017\u65f6 >> {}ms", (Object)(System.currentTimeMillis() - startTime));
            startTime = System.currentTimeMillis();
            rsp = this.getResponseAsString(conn);
            log.info("fshttp >> \u83b7\u53d6\u54cd\u5e94\u7ed3\u679c\u8017\u65f6 >> {}ms", (Object)(System.currentTimeMillis() - startTime));
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String postString(String url, String data, String charset, String contentType, int connectTimeout, int readTimeout, Map<String, String> headers) throws IOException {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new IllegalArgumentException("url is empty");
        }
        if (StringUtils.isBlank((CharSequence)charset)) {
            charset = DEFAULT_CHARSET;
        }
        if (StringUtils.isBlank((CharSequence)contentType)) {
            contentType = JSON_CONTENT_TYPE;
        }
        if (connectTimeout <= 0) {
            connectTimeout = 3000;
        }
        if (readTimeout <= 0) {
            readTimeout = 10000;
        }
        HttpURLConnection conn = null;
        OutputStream out = null;
        String rsp = null;
        byte[] content = new byte[]{};
        if (StringUtils.isNotBlank((CharSequence)data)) {
            content = data.getBytes(charset);
        }
        try {
            long startTime = System.currentTimeMillis();
            conn = this.getConnection(new URL(url), METHOD_POST, contentType, headers);
            log.info("fshttp >> \u521b\u5efahttp\u8fde\u63a5\u8017\u65f6 >> {}ms", (Object)(System.currentTimeMillis() - startTime));
            startTime = System.currentTimeMillis();
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            out = conn.getOutputStream();
            out.write(content);
            log.info("fshttp >> \u53d1\u9001\u8bf7\u6c42\u8017\u65f6 >> {}ms", (Object)(System.currentTimeMillis() - startTime));
            startTime = System.currentTimeMillis();
            rsp = this.getResponseAsString(conn);
            log.info("fshttp >> \u83b7\u53d6\u54cd\u5e94\u7ed3\u679c\u8017\u65f6 >> {}ms", (Object)(System.currentTimeMillis() - startTime));
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String url, Map<String, String> params, String contentType, String charset, int connectTimeout, int readTimeout, Map<String, String> headers) throws IOException {
        if (StringUtils.isBlank((CharSequence)url)) {
            throw new IllegalArgumentException("url is empty");
        }
        if (StringUtils.isBlank((CharSequence)charset)) {
            charset = DEFAULT_CHARSET;
        }
        if (StringUtils.isBlank((CharSequence)contentType)) {
            contentType = DEFAULT_CONTENT_TYPE;
        }
        if (connectTimeout <= 0) {
            connectTimeout = 3000;
        }
        if (readTimeout <= 0) {
            readTimeout = 10000;
        }
        HttpURLConnection conn = null;
        String rsp = null;
        try {
            String query = this.buildQuery(params, charset);
            conn = this.getConnection(this.buildGetUrl(url, query), METHOD_GET, contentType, headers);
            conn.setConnectTimeout(connectTimeout);
            conn.setReadTimeout(readTimeout);
            rsp = this.getResponseAsString(conn);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    public String get(String url) throws IOException {
        return this.get(url, 10000);
    }

    public String get(String url, int timeout) throws IOException {
        return this.get(url, null, DEFAULT_CHARSET, DEFAULT_CONTENT_TYPE, 3000, timeout, null);
    }

    public String post(String url, Map<String, String> param) throws IOException {
        return this.post(url, param, 10000);
    }

    public String post(String url, Map<String, String> param, int timeout) throws IOException {
        return this.post(url, param, DEFAULT_CHARSET, DEFAULT_CONTENT_TYPE, 3000, timeout, null);
    }

    private URL buildGetUrl(String strUrl, String query) throws IOException {
        URL url = new URL(strUrl);
        if (StringUtils.isEmpty((CharSequence)query)) {
            return url;
        }
        strUrl = StringUtils.isEmpty((CharSequence)url.getQuery()) ? (strUrl.endsWith("?") ? strUrl + query : strUrl + "?" + query) : (strUrl.endsWith("&") ? strUrl + query : strUrl + "&" + query);
        return new URL(strUrl);
    }

    private static String getResponseCharset(String ctype) {
        String charset = DEFAULT_CHARSET;
        if (!StringUtils.isEmpty((CharSequence)ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StringUtils.isEmpty((CharSequence)pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
            StringWriter writer = new StringWriter();
            char[] chars = new char[256];
            int count = 0;
            while ((count = reader.read(chars)) > 0) {
                writer.write(chars, 0, count);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    private String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = FsHttpSslRequest.getResponseCharset(conn.getContentType());
        InputStream es = conn.getErrorStream();
        if (es == null) {
            return this.getStreamAsString(conn.getInputStream(), charset);
        }
        String msg = this.getStreamAsString(es, charset);
        if (StringUtils.isEmpty((CharSequence)msg)) {
            throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
        }
        throw new IOException(msg);
    }

    private String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!StringUtils.isNotBlank((CharSequence)name)) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    private HttpURLConnection getConnection(URL url, String method, String contentType, Map<String, String> headers) throws IOException {
        HttpURLConnection conn = null;
        if ("https".equals(url.getProtocol())) {
            HttpsURLConnection connHttps = null;
            connHttps = (HttpsURLConnection)url.openConnection();
            connHttps.setSSLSocketFactory(this.socketFactory);
            connHttps.setHostnameVerifier(this.verifier);
            conn = connHttps;
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", contentType);
        conn.setRequestProperty("Accept", "text/html,application/xhtml+xml,application/xml,application/json;q=0.9,*/*;q=0.8");
        conn.setRequestProperty("Accept-Encoding", "identity");
        conn.setRequestProperty("Accept-Language", "zh-CN,zh;q=0.8");
        conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/68.0.3440.84 Safari/537.36 FsHttpUtil");
        if (headers != null && headers.size() > 0) {
            headers.forEach(conn::setRequestProperty);
        }
        return conn;
    }

    private class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

