/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.kqbill.util;

import com.alibaba.fastjson.JSONObject;
import com.bill99.crypto.config.CryptoConfig;
import com.bill99.crypto.entity.Bill99CertConfig;
import com.bill99.crypto.processor.P7CryptoProcessor;
import com.bill99.crypto.utils.Bill99CertLoader;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;

public class FsCryptoServiceUril {
    private Bill99CertConfig bill99CertConfig;
    P7CryptoProcessor processor = null;

    public FsCryptoServiceUril(DefaultClientConfigModel configModel) throws Exception {
        Bill99CertConfig config = new Bill99CertConfig();
        config.setBill99DefaultPublicPath(configModel.getPayCompanyPublicKey());
        config.setMerchantDefaultPrivatePath(configModel.getFubeiPrivateKey());
        config.setMerchantDefaultPrivatePassword(configModel.getPassword());
        this.setBill99CertConfig(config);
    }

    public void setBill99CertConfig(Bill99CertConfig bill99CertConfig) throws Exception {
        this.bill99CertConfig = bill99CertConfig;
        this.processor = new P7CryptoProcessor();
        CryptoConfig cryptoConfig = Bill99CertLoader.loadCryptoConfig((Bill99CertConfig)this.bill99CertConfig);
        this.processor.setCryptoConfig(cryptoConfig);
    }

    public JSONObject seal(String originalData) throws Exception {
        JSONObject requestBody = new JSONObject();
        requestBody.put("signedData", (Object)this.processor.p7Sign(originalData));
        requestBody.put("envelopedData", (Object)this.processor.p7Envelop(originalData));
        return requestBody;
    }

    public String unSeal(String envelopedData, String signedData) throws Exception {
        String originalData = this.processor.p7OpenEnvelope(envelopedData);
        boolean result = this.processor.p7Verify(originalData, signedData);
        return result ? originalData : null;
    }

    public JSONObject encrypt(String reqData) throws Exception {
        return this.seal(reqData);
    }

    public String decrypt(JSONObject respEncryptBody) throws Exception {
        String respSignedData = respEncryptBody.getString("signedData");
        String respEnvelopedData = respEncryptBody.getString("envelopedData");
        return this.unSeal(respEnvelopedData, respSignedData);
    }
}

