/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.kqbill.response.trade.detail;

import lombok.Data;

/**
 * @author wangqilei
 * @version PromotionDetail.java, v 0.1 2024-07-08 9:31 AM wangqilei
 */
@Data
public class PromotionDetail {
    /**
     * 优惠券ID，用于标识特定优惠券
     * (特殊必填)
     */
    private String couponId;

    /**
     * 优惠活动ID，商家或平台分配的唯一标识
     * (选填)
     */
    private String discountId;

    /**
     * 优惠活动的中文名称
     * (特殊必填)
     */
    private String discountName;

    /**
     * 优惠活动的适用范围，如GLOBAL或SINGLE
     * (特殊必填)
     */
    private String discountScope;

    /**
     * 优惠类型
     * 1、微信：
     * COUPON - 代金券
     * DISCOUNT - 优惠券
     * 2、支付宝：
     * ALIPAY_FIX_VOUCHER - 全场代金券
     * ALIPAY_DISCOUNT_VOUCHER - 折扣券
     * ALIPAY_ITEM_VOUCHER - 单品优惠
     * 3、银联
     * DD01-随机立减
     * CP01-代金券 1：无需领取，交易时直接适
     * 配并承兑的优惠券
     * CP01-代金券 2：事前领取，交易时上送银
     * 联并承兑的优惠券
     * (特殊必填)
     */
    private String discountType;

    /**
     * 优惠总金额，商家出资金额+其他方出资+平台出资
     * (必填)
     */
    private String eventDiscountAmount;

    /**
     * 平台出资金额
     * (特殊必填)
     */
    private String platformDiscountAmount;

    /**
     * 商户出资金额
     * (特殊必填)
     */
    private String merchantDiscountAmount;

    /**
     * 第三方提供的优惠金额
     * (特殊必填)
     */
    private String thirdPartyDiscountAmount;
}