/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.kqbill.response.trade;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.kqbill.response.KqbillBizRes;
import com.fshows.kqbill.response.trade.detail.PayInfo;
import lombok.Data;

/**
 * @author wangqilei
 * @version KqbillOrderPayRes.java, v 0.1 2024-06-05 3:55 PM wangqilei
 */
@Data
public class KqbillJsApiPayCreateRes extends KqbillBizRes {
    private static final long serialVersionUID = -8880687432977995532L;

    /**
     * 快钱公司分配给商户的8位唯一标识号
     * (必填)
     */
    private String terminalId;

    /**
     * 快钱公司分配给商户的15位唯一标识号
     * (必填)
     */
    private String merchantId;

    /**
     * 请求提交的支付类型
     * (必填)
     */
    private String userAgent;

    /**
     * 非必填，订单控制编号
     * (选填)
     */
    private String idOrderCtrl;

    /**
     * 非必填，交易控制编号
     * (选填)
     */
    private String idTxnCtrl;

    /**
     * 非必填，快钱提供的交易编号
     * (选填)
     */
    @JSONField(name = "IdTxn")
    private String idTxn;

    /**
     * JSON 格式数据，唤起微信/支付宝支付的参数；
     */
    private PayInfo payInfo;
}