/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.kqbill.request.trade.detail;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.List;

/**
 * @author wangqilei
 * @version SharingInfo.java, v 0.1 2024-07-03 4:38 PM wangqilei
 */
@Data
public class SharingInfo {
    /**
     * 1 - 分账标志，若后台未开通平台分账则无效
     * (特殊必填)
     */
    private Integer sharingFlag;

    /**
     * 手续费收取方方式，sharingFlag为1时必填，0:主收款方承担，1:各分账方均摊
     * (必填)
     */
    private Integer feeMode;

    /**
     * 当feeMode为0时必填，手续费承担商户的useId
     * (选填)
     */
    @Length(max = 22, message = "feePayer长度不能超过22")
    private String feePayer;

    /**
     * 分账明细
     */
    @NotBlank
    private List<SharingData> sharingDataList;
}