/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.kqbill.handler;

import cn.hutool.http.HttpRequest;
import com.fshows.kqbill.util.FsHttpSslRequest;
import com.fshows.sdk.core.client.base.handler.IHttpRequestHandler;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.util.FsHttpUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;

/**
 * @author wangqilei
 * @version KqbillPostHttpWithSSLRequestHandler.java, v 0.1 2024-07-04 9:17 AM wangqilei
 */
@Slf4j
public class NewKqbillPostWithSSLRequestHandler implements IHttpRequestHandler {
    private static final int SO_TIMEOUT = 60 * 1000;
    private static final int CONN_TIMEOUT = 10 * 1000;
    private FsHttpSslRequest fsHttpSslRequest = null;

    public NewKqbillPostWithSSLRequestHandler(DefaultClientConfigModel configModel) {
        fsHttpSslRequest = new FsHttpSslRequest((KqbillClientConfigModel) configModel);
    }

    @Override
    public ApiResponseModel httpRequest(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws IOException {
        DefaultClientConfigModel apiClientConfig = requestContext.getApiClientConfig();

        String fsHttpResult = fsHttpSslRequest.postString(apiRequestModel.getApiURL(), apiRequestModel.getRequestBody(), apiClientConfig.getCharset(), apiRequestModel.getContentType(), apiClientConfig.getConnectionTimeout(), apiClientConfig.getReadTimeout(), apiRequestModel.getHeadMap());
        ApiResponseModel responseModel = new ApiResponseModel();
        responseModel.setResponseBody(fsHttpResult);
        log.info("httpRequest >> 请求返回结果 >> {}", responseModel);
        return responseModel;
    }
}