/*
 * Decompiled with CFR 0.152.
 */
package com.fshows;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fshows.request.JlBizRequest;
import com.fshows.response.JlBizResponse;
import com.fshows.sdk.core.client.base.AbstractApiClient;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.ClientInfoModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.sdk.core.util.FsHttpUtil;
import com.fshows.sdk.core.util.LogUtil;
import com.fshows.sdk.core.util.ReqIdUtil;
import com.jlpay.open.jlpay.sdk.java.exception.HttpExecutionException;
import com.jlpay.open.jlpay.sdk.java.http.HttpMethod;
import com.jlpay.open.jlpay.sdk.java.http.HttpRequest;
import com.jlpay.open.jlpay.sdk.java.sign.SignVerifier;
import com.jlpay.open.jlpay.sdk.java.sign.SignVerifierManager;
import com.jlpay.open.jlpay.sdk.java.utils.HttpUtils;
import com.jlpay.open.jlpay.sdk.java.utils.NonceUtils;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JlPayApiClient
extends AbstractApiClient<JlBizRequest, JlBizResponse, IApiDefinition> {
    private static final Logger log = LoggerFactory.getLogger(JlPayApiClient.class);
    private final SignVerifierManager signVerifierManager;
    private static final ObjectMapper INSTANCE = new ObjectMapper();

    public JlPayApiClient(DefaultClientConfigModel apiClientConfig) throws FsApiException {
        super(apiClientConfig);
        try {
            SignVerifier signVerifier = new SignVerifier(apiClientConfig.getFubeiPrivateKey(), apiClientConfig.getPayCompanyPublicKey());
            this.signVerifierManager = new SignVerifierManager(signVerifier);
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"JlPayApiClient >> \u5609\u8054\u901a\u9053\u516c\u79c1\u94a5\u52a0\u8f7d\u5931\u8d25! ", (Throwable)e);
            throw new FsApiException("\u52a0\u8f7d\u516c\u79c1\u94a5\u5931\u8d25", (Throwable)e);
        }
    }

    public JlBizResponse execute(JlBizRequest request, IApiDefinition apiDefinition) throws FsApiException {
        return (JlBizResponse)this.doExecute(request, apiDefinition);
    }

    public JlBizResponse execute(JlBizRequest request, IApiDefinition apiDefinition, DefaultClientConfigModel configModel) throws FsApiException {
        return this.doExecute(request, apiDefinition, configModel);
    }

    protected JlBizResponse doExecute(JlBizRequest request, IApiDefinition iApiDefinition, DefaultClientConfigModel payConfigModel) throws FsApiException {
        long beginTime = System.currentTimeMillis();
        LogUtil.info((Logger)log, (String)"{} >> \u8bf7\u6c42\u5f00\u59cb >> iApiDefinition={}, request={}", (Object[])new Object[]{this.getClientInfo().getClientDesc(), iApiDefinition, request});
        DefaultRequestContext requestContext = this.buildRequestContext(iApiDefinition, request, payConfigModel);
        ApiRequestModel apiRequestModel = null;
        ApiResponseModel apiResponseModel = null;
        try {
            this.checkParam(request, requestContext);
            apiRequestModel = this.buildApiRequestModel(request, requestContext);
            long reqBeginTime = System.currentTimeMillis();
            apiResponseModel = this.httpRequest(apiRequestModel, requestContext);
            long reqEndTime = System.currentTimeMillis();
            Object requestBody = ObjectUtils.defaultIfNull((Object)apiRequestModel.getRequestBody(), (Object)apiRequestModel.getRequestForm());
            LogUtil.info((Logger)log, (String)"{} >> \u8bf7\u6c42\u7ed3\u675f >> url={}, method={}, request={}, response={}, cost={}ms", (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel.getApiURL(), iApiDefinition, requestBody, apiResponseModel.getResponseBody(), reqEndTime - reqBeginTime});
            return this.buildApiResponse(apiResponseModel, apiRequestModel, requestContext);
        }
        catch (FsApiException e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u5f02\u5e38 >> url={}, method={}, request={}, cost={}ms", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel == null ? "" : apiRequestModel.getApiURL(), requestContext.getIApiDefinition(), JSONObject.toJSONString((Object)(apiRequestModel == null ? "" : apiRequestModel.getRequest())), System.currentTimeMillis() - beginTime});
            throw e;
        }
        catch (Exception e) {
            LogUtil.info((Logger)log, (String)"{} >> \u8bf7\u6c42\u672a\u77e5\u5f02\u5e38 >> url={}, method={}, request={}, cost={}ms", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel == null ? "" : apiRequestModel.getApiURL(), requestContext.getIApiDefinition(), JSONObject.toJSONString((Object)(apiRequestModel == null ? "" : apiRequestModel.getRequest())), System.currentTimeMillis() - beginTime});
            throw new FsApiException(e.getMessage(), (Throwable)e);
        }
    }

    protected DefaultRequestContext buildRequestContext(IApiDefinition apiDefinitionEnum, JlBizRequest request, DefaultClientConfigModel payConfig) {
        DefaultRequestContext context = new DefaultRequestContext();
        context.setRequestId(ReqIdUtil.getId());
        context.setIApiDefinition(apiDefinitionEnum);
        DefaultClientConfigModel config = (DefaultClientConfigModel)BeanUtil.copyProperties((Object)this.apiClientConfig, DefaultClientConfigModel.class, (String[])new String[0]);
        if (payConfig != null) {
            config.setAgentId(StringUtils.isEmpty((CharSequence)payConfig.getAgentId()) ? this.apiClientConfig.getAgentId() : payConfig.getAgentId());
            config.setAppId(StringUtils.isEmpty((CharSequence)payConfig.getAppId()) ? this.apiClientConfig.getAppId() : payConfig.getAppId());
            config.setFubeiPrivateKey(StringUtils.isEmpty((CharSequence)payConfig.getFubeiPrivateKey()) ? this.apiClientConfig.getFubeiPrivateKey() : payConfig.getFubeiPrivateKey());
            config.setPayCompanyPublicKey(StringUtils.isEmpty((CharSequence)payConfig.getPayCompanyPublicKey()) ? this.apiClientConfig.getPayCompanyPublicKey() : payConfig.getPayCompanyPublicKey());
        }
        context.setApiClientConfig(config);
        context.setClientInfoModel(this.getClientInfo());
        return context;
    }

    protected ApiRequestModel buildApiRequestModel(JlBizRequest request, DefaultRequestContext context) {
        String requestBody;
        DefaultClientConfigModel configModel = context.getApiClientConfig();
        ApiRequestModel apiRequestModel = new ApiRequestModel();
        apiRequestModel.setApiURL(configModel.getApiParentURL() + context.getIApiDefinition().getApiURI());
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("Content-Type", "application/json; charset=utf-8");
        headerMap.put("Accept", "application/json; charset=utf-8");
        headerMap.put("x-jlpay-appid", configModel.getAppId());
        String randomStr = NonceUtils.createNonce((int)32);
        String timestamp = String.valueOf(Instant.now().getEpochSecond());
        headerMap.put("x-jlpay-nonce", randomStr);
        headerMap.put("x-jlpay-timestamp", timestamp);
        headerMap.put("x-jlpay-sign-alg", "SM3WithSM2WithDer");
        apiRequestModel.setHeadMap(headerMap);
        apiRequestModel.setContentType("application/json; charset=utf-8");
        try {
            requestBody = INSTANCE.writeValueAsString((Object)request);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
        apiRequestModel.setRequestBody(requestBody);
        return apiRequestModel;
    }

    protected ClientInfoModel getClientInfo() {
        ClientInfoModel clientInfoModel = new ClientInfoModel();
        clientInfoModel.setClientName("\u5609\u8054");
        clientInfoModel.setClientCode("jlpay-sdk");
        return clientInfoModel;
    }

    protected JlBizResponse buildApiResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        JSONObject resJson = JSONObject.parseObject((String)apiResponseModel.getResponseBody());
        return (JlBizResponse)resJson.toJavaObject(requestContext.getIApiDefinition().getResponseClass());
    }

    protected ApiResponseModel httpRequest(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws IOException {
        HttpRequest postRequest = HttpRequest.builder().url(HttpUtils.parseUrl((String)apiRequestModel.getApiURL())).headers(apiRequestModel.getHeadMap()).body(apiRequestModel.getRequestBody()).method(HttpMethod.POST).addHeader("x-jlpay-timestamp", String.valueOf(Instant.now().getEpochSecond())).addHeader("x-jlpay-nonce", NonceUtils.createNonce((int)32)).addHeader("x-jlpay-sign-alg", "SM3WithSM2WithDer").build();
        String sign = this.signVerifierManager.sign(postRequest);
        postRequest.addHeader("x-jlpay-sign", sign);
        String responseBody = this.sendPost(postRequest);
        ApiResponseModel responseModel = new ApiResponseModel();
        responseModel.setResponseBody(responseBody);
        return responseModel;
    }

    private String sendPost(HttpRequest httpRequest) {
        String body = httpRequest.getBody();
        httpRequest.getHeaders().put("Accept-Encoding", "identity");
        try {
            return FsHttpUtil.postString((String)httpRequest.getUrl().toString(), (String)body, (String)"", (String)"", (int)10000, (int)10000, (Map)httpRequest.getHeaders());
        }
        catch (IOException e) {
            throw new HttpExecutionException(String.format("Http Client execute failed, request: %s", httpRequest), (Throwable)e);
        }
    }

    static {
        INSTANCE.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        INSTANCE.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        INSTANCE.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        INSTANCE.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_USING_DEFAULT_VALUE, true);
        INSTANCE.enable(DeserializationFeature.FAIL_ON_NUMBERS_FOR_ENUMS);
        INSTANCE.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        INSTANCE.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
        INSTANCE.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        INSTANCE.setTimeZone(TimeZone.getTimeZone("GMT+8"));
    }
}

