/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.response;

import lombok.Data;
import lombok.ToString;

/**
 * 订单取消 response
 *
 * @author
 * @version JlOpenTransCancelResponse.java, v 0.1 2025-01-08 17:37:48
 */
@Data
@ToString(callSuper = true)
public class JlOpenTransCancelResponse extends JlBizResponse {
    private static final long serialVersionUID = 326691565760087398L;

    /**
     * 状态，示例值：2
     * 2表示成功，3表示失败，表示该交易的状态
     */
    private String status;

    /**
     * 平台订单号，示例值：8001155720190917185301156894
     * 返回的嘉联平台订单号，用于标识平台的交易订单
     */
    private String transactionId;

    /**
     * 商家系统内部生成的订单号，用于标识商家的订单
     */
    private String outTradeNo;

    /**
     * 渠道平台订单号，示例值：2019092300012345
     * 渠道平台生成的订单号，用于标识渠道平台的交易订单
     */
    private String chnTransactionId;

    /**
     * 原外部订单号，示例值：019091700000234
     * 商家系统内部的原订单号，用于标识商家的原始订单
     */
    private String oriOutTradeNo;

    /**
     * 原平台订单号，示例值：8001155720190917185301156894
     * 嘉联平台的原交易订单号，必填字段，用于查询原始交易信息
     */
    private String oriTransactionId;

    /**
     * 订单时间，示例值：2019-10-22 16:46:58
     * 请求订单的时间，格式为yyyy-MM-dd HH:mm:ss，用于记录订单的创建时间
     */
    private String orderTime;

    /**
     * 支付类型，示例值：wxpay
     * 表示交易的支付方式，可能的值有：wxpay（微信支付）、alipay（支付宝）、unionpay（银联支付）等
     */
    private String payType;

    /**
     * 交易金额，示例值：200
     * 订单总金额，单位为分，只能为整数，表示该订单的金额
     */
    private String totalFee;

    /**
     * 交易时间，示例值：2019-10-22 16:46:58
     * 交易完成的时间，格式为yyyy-MM-dd HH:mm:ss，用于记录交易处理的时间
     */
    private String transTime;
}