/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;
import lombok.ToString;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 订单退款 request
 *
 * @author
 * @version JlOpenTransRefundRequest.java, v 0.1 2025-01-08 17:37:48
 */
@Data
@ToString(callSuper = true)
public class JlOpenTransRefundRequest extends JlBizRequest {
    private static final long serialVersionUID = 1554839458243819252L;

    /**
     * 商家系统内部退款订单号
     * (必填)
     */
    @NotBlank(message = "外部订单号不能为空")
    @Length(max = 32, message = "外部订单号长度不能超过32")
    private String outTradeNo;

    /**
     * 商家系统内部原交易订单号（原外部订单号、原平台订单号二选一）
     * (选填)
     */
    @Length(max = 32, message = "原外部订单号长度不能超过32")
    private String oriOutTradeNo;

    /**
     * 原交易嘉联订单号（原外部订单号、原平台订单号二选一），示例值：80011557201909171853011568
     * (选填)
     */
    @Length(max = 32, message = "原平台订单号长度不能超过32")
    private String oriTransactionId;

    /**
     * 退款金额，以分为单位，只能为整数，示例值：1000 表示 10.00 元
     * (必填)
     */
    @NotBlank(message = "交易金额不能为空")
    @Length(max = 15, message = "交易金额长度不能超过15")
    private String totalFee;

    /**
     * 备注信息，该字段内容会随交易结果透传推送给接入方
     * (选填)
     */
    @Length(max = 500, message = "备注长度不能超过500")
    private String remark;

    /**
     * 商户端退款终端设备IP地址，须公网IP，示例值：10.18.253.30
     * (选填)
     * 注：如经、纬度信息未上送，该字段必送
     */
    @Length(max = 60, message = "终端IP长度不能超过60")
    private String mchCreateIp;

    /**
     * 设备经度，百度坐标系，示例值：116.078631
     * (选填)
     */
    @Length(max = 10, message = "经度长度不能超过10")
    private String longitude;

    /**
     * 设备纬度，百度坐标系，示例值：39.71274
     * (选填)
     */
    @Length(max = 10, message = "纬度长度不能超过10")
    private String latitude;
}