/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.request;

import lombok.Data;
import lombok.ToString;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * 订单查询 request
 *
 * @author
 * @version JlOpenTransCancelRequest.java, v 0.1 2025-01-08 17:37:48
 */
@Data
@ToString(callSuper = true)
public class JlOpenTransCancelRequest extends JlBizRequest {

    private static final long serialVersionUID = -7761734687790444091L;

    /**
     * 外部订单号，示例值：0190917000002498
     * 商家系统内部撤销订单号，用于标识商家的订单
     * (必填)
     */
    @NotBlank(message = "outTradeNo不能为空")
    @Length(max = 32, message = "outTradeNo长度不能超过32")
    private String outTradeNo;

    /**
     * 原外部订单号，示例值：019091700000234
     * 商家系统内部原交易订单号，原外部订单号或原平台订单号二选一
     * (选填)
     */
    @Length(max = 32, message = "oriOutTradeNo长度不能超过32")
    private String oriOutTradeNo;

    /**
     * 原平台订单号，示例值：80011557201909171853011568
     * 原交易嘉联订单号，原外部订单号或原平台订单号二选一
     * (选填)
     */
    @Length(max = 32, message = "oriTransactionId长度不能超过32")
    private String oriTransactionId;

    /**
     * 备注信息，示例值：无
     * 用于添加额外的备注说明
     * (选填)
     */
    @Length(max = 500, message = "remark长度不能超过500")
    private String remark;

    /**
     * 商户端交易终端设备IP地址，示例值：10.18.253.30
     * 必须是公网IP地址，通常用于标识发起请求的设备
     * (选填)
     */
    @Length(max = 60, message = "mchCreateIp长度不能超过60")
    private String mchCreateIp;

    /**
     * 地理位置经度，示例值：116.078631
     * 设备经度，采用百度坐标系，选填
     * (选填)
     */
    @Length(max = 10, message = "longitude长度不能超过10")
    private String longitude;

    /**
     * 地理位置纬度，示例值：39.71274
     * 设备纬度，采用百度坐标系，选填
     * (选填)
     */
    @Length(max = 10, message = "latitude长度不能超过10")
    private String latitude;
}