/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package
        com.fshows.request;

import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author
 * @version JlBizRequest.java, v 0.1 2025-01-08 17:37:48
 */
@Data
public class JlBizRequest implements IRequestDefinition {

    private static final long serialVersionUID = -8741013352746220359L;
    /**
     * 商户号，示例值：849440358120001
     * 嘉联分配的商户号，用于唯一标识商户
     * (必填)
     */
    @Length(max = 15, message = "mchId长度不能超过15")
    private String mchId;
}