/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.response;

import lombok.Data;
import lombok.ToString;

/**
 * 订单退款 response
 *
 * @author
 * @version JlOpenTransRefundResponse.java, v 0.1 2025-01-08 17:37:48
 */
@Data
@ToString(callSuper = true)
public class JlOpenTransRefundResponse extends JlBizResponse {
    private static final long serialVersionUID = -5755514179238645189L;

    /**
     * 状态，示例值：2
     * 2：成功，3：失败
     */
    private String status;

    /**
     * 返回的嘉联退款订单号，示例值：8001155720190917185301156894
     */
    private String transactionId;

    /**
     * 商家系统内部退款订单号
     */
    private String outTradeNo;

    /**
     * 支付宝,微信,银联侧订单号，示例值：4200000438201912172642934851
     */
    private String chnTransactionId;

    /**
     * 商家系统内部原交易订单号
     */
    private String oriOutTradeNo;

    /**
     * 原交易嘉联订单号，示例值：8001155720190971853011568
     */
    private String oriTransactionId;

    /**
     * 交易金额，以分为单位，只能为整数，示例值：1000 表示 10.00 元
     */
    private String totalFee;

    /**
     * 退款请求时间，形如：yyyy-MM-dd HH:mm:ss
     */
    private String orderTime;

    /**
     * 交易类型，示例值：wxpay, alipay, unionpay
     */
    private String payType;

    /**
     * 退款处理时间，形如：yyyy-MM-dd HH:mm:ss
     */
    private String transTime;
}