/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.response;

import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * 渠道商户信息查询 response
 *
 * @author
 * @version JlOpenMerchAccessMerchChannelInfoQueryResponse.java, v 0.1 2025-01-08 17:37:48
 */
@Data
@ToString(callSuper = true)
public class JlOpenMerchAccessMerchChannelInfoQueryResponse extends JlBizResponse {

    private static final long serialVersionUID = 2555642233132106001L;
    /**
     * 商户号
     */
    private String merchNo;

    /**
     * 渠道信息列表
     */
    private List<ChannelInfo> channelInfo;


    /**
     * 渠道信息类
     */
    @Data
    @ToString(callSuper = true)
    public static class ChannelInfo implements Serializable {
        private static final long serialVersionUID = -8254736473070476642L;
        /**
         * 渠道ID
         */
        private String channelId;

        /**
         * 渠道服务商号
         */
        private String channelOrgId;

        /**
         * 渠道商户号
         */
        private String channelMerchNo;

        /**
         * 渠道商户名称
         */
        private String channelMerchName;

        /**
         * 渠道经营名称
         */
        private String channelMerchShortname;

        /**
         * 商户报备状态
         */
        private String reportStatus;

        /**
         * 报备结果描述
         */
        private String failReason;

        /**
         * 报备时间
         */
        private String reportTime;

        /**
         * 微信费率类型
         */
        private String wxFeeType;

        /**
         * 支付宝费率类型
         */
        private String aliFeeType;
    }
}